% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rUV_fc.R
\name{rUV_fc}
\alias{rUV_fc}
\title{Gibbs sampling of U and V}
\usage{
rUV_fc(Z, U, V, Suv, rho, s2 = 1, offset = 0)
}
\arguments{
\item{Z}{n X n normal relational matrix}

\item{U}{current value of U}

\item{V}{current value of V}

\item{Suv}{covariance of (U V)}

\item{rho}{dyadic correlation}

\item{s2}{dyadic variance}

\item{offset}{a matrix of the same dimension as Z. It is assumed that
Z-offset is equal to the multiplicative effects plus dyadic noise, so the 
offset should contain any additive effects (such as \code{Xbeta(X,beta+ 
outer(a,b,"+")  }  )}
}
\value{
\item{U}{a new value of U} \item{V}{a new value of V}
}
\description{
A Gibbs sampler for updating the multiplicative effect matrices U and V
}
\author{
Peter Hoff
}
