% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df_to_faa.R
\name{df_to_faa}
\alias{df_to_faa}
\title{Save a dataframe in FASTA format}
\usage{
df_to_faa(df, file = "")
}
\arguments{
\item{df}{a dataframe containing two columns: the sequence name and amino acid sequence itself}

\item{file}{file path to save the named file to}
}
\value{
A FASTA file where protein sequences are represented in two lines: The protein name preceded by a greater than symbol,
        and a new second line that contains the protein sequence
}
\description{
This function writes a dataframe out as a FASTA format file
}
\examples{

my_protein <- read_faa(system.file("extdata/bat_protein.fasta", package = "ampir"))

# Write a dataframe to a FASTA file
df_to_faa(my_protein, tempfile("my_protein.fasta", tempdir()))


}
