% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_distr.R
\name{fit_sl_dist}
\alias{fit_sl_dist}
\alias{fit_sl_dist_base}
\title{Fit a statistical distribution to step lengths.}
\usage{
fit_sl_dist(.tbl, x, ...)

fit_sl_dist_base(x, na.rm = TRUE, distr = "gamma", ...)
}
\arguments{
\item{.tbl}{\code{[track_xy,track_xyt]} \cr A track.}

\item{x}{\code{[expression]} \cr The name of the column containing step lengths, usually \code{sl_}.}

\item{...}{Further arguments, none implemented.}

\item{na.rm}{\code{[logical(1)]} \cr Should \code{NA} be removed?}

\item{distr}{\code{[character(1)]{'gamma', 'exp', 'unif'}} \cr Name of the distribution, currently only \code{gamma}, \code{unif}, and \code{exponential} distributions are supported.}
}
\description{
Fit a statistical distribution to step lengths.
}
\examples{
data(deer)
stps <- steps_by_burst(deer)
fit_sl_dist(stps, sl_)
}
