% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/droplet-actions.R
\name{droplet_snapshot}
\alias{droplet_backups_list}
\alias{droplet_restore}
\alias{droplet_snapshot}
\alias{droplet_snapshots_list}
\title{Take and restore snapshots.}
\usage{
droplet_snapshot(droplet, name = NULL, ...)

droplet_snapshots_list(droplet, ...)

droplet_restore(droplet, image, ...)

droplet_backups_list(droplet, ...)
}
\arguments{
\item{droplet}{A droplet number or the result from a call to
\code{droplets()}}

\item{name}{(character) Optional. Name of the new snapshot you want to
create. If not set, the  snapshot name will default to the current date/time}

\item{...}{Additional options passed down to \code{\link[httr]{POST}}}

\item{image}{(optional) The image ID of the backup image that you would like
to restore.}
}
\description{
\describe{
\item{snapshot}{Take a snapshot of the droplet once it has been powered
  off, which can later be restored or used to create a new droplet from
  the same image. Please be aware this may cause a reboot.}
\item{snapshots_list}{List available snapshots}
\item{backups_list}{List available snapshots}
\item{restore}{Restore a droplet with a previous image or snapshot.
  This will be a mirror copy of the image or snapshot to your droplet. Be
  sure you have backed up any necessary information prior to restore.}
}
}
\examples{
\dontrun{
d <- droplet_create()
d \%>\% droplet_snapshots_list()
d \%>\% droplet_backups_list()

d \%>\%
  droplet_power_off() \%>\%
  droplet_snapshot() \%>\%
  droplet_power_on() \%>\%
  droplet_snapshots_list()

# To delete safely
d \%>\%
  droplet_power_off() \%>\%
  droplet_snapshot() \%>\%
  droplet_delete() \%>\%
  action_wait()
}
}

