% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-functions.R, R/core-functions-batch.R,
%   R/core-streaming-functions.R
\docType{methods}
\name{generateOutput}
\alias{generateOutput}
\alias{generateOutput,AnalysisPipeline-method}
\alias{generateOutput,StreamingAnalysisPipeline-method}
\title{Generate a list of outputs from Pipeline objects}
\usage{
generateOutput(object)

\S4method{generateOutput}{AnalysisPipeline}(object)

\S4method{generateOutput}{StreamingAnalysisPipeline}(object)
}
\arguments{
\item{object}{object that contains input, pipeline, registry and output}
}
\value{
Updated Pipeline object with the outputs at each step stored in the \code{output} slot.

Specific outputs can be obtained by using the \link{getOutputById} function
}
\description{
Generate a list of outputs from Pipeline objects
}
\details{
\code{generateOutput} is a generic function that is implemented for various types of pipeline objects
such as \code{AnalysisPipeline} and \code{StreamingAnalysisPipeline}

The sequence of operations stored in the pipeline object
      are run and outputs generated, stored in a list
}
\seealso{
Other Package core functions: \code{\link{BaseAnalysisPipeline-class}},
  \code{\link{MetaAnalysisPipeline-class}},
  \code{\link{assessEngineSetUp}},
  \code{\link{checkSchemaMatch}},
  \code{\link{createPipelineInstance}},
  \code{\link{exportAsMetaPipeline}},
  \code{\link{genericPipelineException}},
  \code{\link{getInput}}, \code{\link{getLoggerDetails}},
  \code{\link{getOutputById}},
  \code{\link{getPipelinePrototype}},
  \code{\link{getPipeline}}, \code{\link{getRegistry}},
  \code{\link{initDfBasedOnType}},
  \code{\link{initialize,BaseAnalysisPipeline-method}},
  \code{\link{loadMetaPipeline}},
  \code{\link{loadPipeline}},
  \code{\link{loadPredefinedFunctionRegistry}},
  \code{\link{loadRegistry}}, \code{\link{prepExecution}},
  \code{\link{registerFunction}},
  \code{\link{savePipeline}}, \code{\link{saveRegistry}},
  \code{\link{setInput}}, \code{\link{setLoggerDetails}},
  \code{\link{updateObject}},
  \code{\link{visualizePipeline}}
}
\concept{Package core functions}
