% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anglr-package.R
\docType{package}
\name{anglr-package}
\alias{anglr-package}
\title{Mesh topology and visualization for spatial mesh structures.}
\description{
The  anglr package gives direct access to generic 3D tools and provides a
full suite of mesh-creation and 3D plotting functions. By extending the rgl
package conversion and visualization functions for the \code{mesh3d} class a wide
variety of complex spatial data can be brought into 3D scenes. These tools
allow for spatial raster, polygons, and lines that are common in GIS
contexts to be converted into mesh forms with high flexibility and the
ability to integrate disparate data types. Vector and raster data can be
seamlessly combined as meshes, and surfaces can be set to have material
properties based on data values or with image textures. Textures and other
data combinations use projection transformations to map between coordinate
systems, and objects can be easily visualized in an interactive scene at any
stage.
}
\details{
The 'anglr' package show-cases extended features for \emph{geo}-spatial data by
extending and supporting the data models of the silicate package. Any kind
of spatial data is intended to be supported, not just the geographic ones:
\itemize{
\item coordinates beyond X and Y, or longitude and latitude
\item storing attributes on vertices, primitives, branches (parts), or objects
\item topology and geometry are distinguishable and not conflated
\item spatial data can be represented as a graph of spatial primitives
\item polygons as true surfaces, not just path structures with a 2D-only region-filling rule
\item TBD higher dimensional primitives are possible
\item TBD n-dimensional rasters with curvilinear coordinates, and the discrete-continuous distinction
}
}
\section{Licensing}{


The anglr package is released with license CC BY-NC-SA 4.0 to match the one
dependency RTriangle. Please note and respect the license of the RTriangle
package used by the \code{\link[=DEL]{DEL()}} or \code{\link[=DEL0]{DEL0()}} functions in anglr, and invoked
within 3D plot methods. These return high-quality constrained Delaunay
triangulations of polygonal regions, with the ability to control mesh
characteristics including maximum triangle area, minimum internal angle, and
conformance to the Delaunay criterion. If you are interested in
a less restrictive license for high-quality meshing in R please
get involved with \href{https://github.com/hypertidy/laridae}{the laridae package}
which aims to provide access to \href{https://www.cgal.org/}{CGAL}.
}

\section{Creation}{

\tabular{ll}{
\code{\link[rgl]{as.mesh3d}} \tab coercion function to convert most spatial data to mesh forms \cr
\code{\link[silicate]{SC}}  \tab and other silicate models are all supported, including the structural forms SC0, TRI0, PATH0 \cr
\code{\link[sp]{Spatial}} \tab most spatial types can be used directly including raster and sf \cr
\code{\link{DEL}} \tab create a mostly-Delaunay shape-preserving constrained triangulation  \cr
}
}

\section{III. Plotting}{


As much as possible plotting will represent the true nature of the data given.

\tabular{ll}{
\code{\link{mesh_plot}} \tab plot in 2D, including curvilinear reprojections with rasters \cr
\code{\link[rgl]{plot3d}} \tab and related 3D plot functions in rgl can be used directly on most input types \cr
\code{\link{globe}} \tab convert X,Y planar or angular to 3D on the surface of a globe, based on the data in longitude-latitude form \cr
\code{\link{plot3d.SC}} \tab plot 1D topology in 3D geometry space \cr
\code{\link{plot3d.TRI}} \tab plot 2D topology in 3D geometry space (DEL or TRI) \cr
}
}

\section{Options and technicalities}{


There is an option set for the maximum number of triangles that can be
generated by the \code{\link[=DEL]{DEL()}} or \code{\link[=DEL0]{DEL0()}} models when using the \code{max_area}
argument. Inspect the limit with \code{getOption("anglr.max.triangles")} or set a
new limit with \verb{options(anglr.max.triangles = <new limit>)}.

In terms of the \code{\link[RTriangle:triangulate]{RTriangle::triangulate()}} function the \code{max_area} argument
controls and masks the \code{a} argument for RTriangle. It's possible to pass in
values for \code{q}, \code{Y}, \code{j}, \code{D}, \code{S}, \code{V}, and \code{Q} - but we don't recommend
experimenting with these unless you know what they are for. There is a
coarse check for a limit on the number of triangles that can be created but
general caution is advised when experimenting.
}

