% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global_confidence_intervals.R
\name{obtain_global_confidence_intervals}
\alias{obtain_global_confidence_intervals}
\title{To obtain 95\% confidence intervals around the observed global network statistics}
\usage{
obtain_global_confidence_intervals(
  network,
  n_versions = 100,
  network_metrics_functions_list = c(edge_density = function(x) igraph::edge_density(x),
    diameter = function(x) igraph::diameter(x, weights = NA), transitivity = function(x)
    igraph::transitivity(x))
)
}
\arguments{
\item{network}{An igraph object}

\item{n_versions}{Number of bootstrapped versions to be used. (default = 100)}

\item{network_metrics_functions_list}{A list consisting of function definitions of the network metrics that the user wants to evaluate. Each element in the list should have an assigned name.
Default = c("edge_density" = function(x) igraph::edge_density(x), "diameter" = function(x) igraph::diameter(x, weights = NA), "transitivity" = function(x) igraph::transitivity(x))}
}
\value{
A DataFrame consisting of three columns. The first column contains the value of observed network metric, the second and 
third column represent the lower and upper limit of 95% confidence interval respectively. The rows correspond to the network metrics chosen to evaluate.
}
\description{
To obtain 95\% confidence intervals around the observed global network statistics
}
\examples{
\donttest{
data(elk_network_2010)
obtain_global_confidence_intervals(elk_network_2010, n_versions = 100, 
network_metrics_functions_list = c("edge_density" = function(x) igraph::edge_density(x),
"diameter" = function(x) igraph::diameter(x, weights = NA),
"transitivity" = function(x) igraph::transitivity(x)))
}
}
