% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{sqlite.build}
\alias{sqlite.build}
\title{Build annovarR database in sqlite}
\usage{
sqlite.build(filename = NULL, sqlite.connect.params = list(dbname = "",
  table.name = ""), dat = data.table(), fread.params = list(),
  new.colnames = NULL, overwrite = TRUE, verbose = FALSE, ...)
}
\arguments{
\item{filename}{Path of raw data, will be read by fread}

\item{sqlite.connect.params}{Connect to sqlite database params [dbname, table.name]}

\item{dat}{Object of data.table, as the input data to build database (optional)}

\item{fread.params}{Other parameters be used in \code{\link[data.table]{fread}}}

\item{new.colnames}{New colnames of table, default is to retain the original}

\item{overwrite}{Ligical indicating wheather overwrite sqlite database}

\item{verbose}{Ligical indicating wheather show the log message}

\item{...}{Other parameters be used in dbWriteTable}
}
\description{
Build annovarR database in sqlite
}
\examples{
test.dat <- system.file('extdata', 'demo/sqlite.dat.txt', package = 'annovarR')
test.sqlite <- sprintf('\%s/snp.test.sqlite', tempdir())
x <- sqlite.build(filename = test.dat, list(dbname = test.sqlite, 
table.name = 'snp_test'))
test.sqlite <- normalizePath(test.sqlite, '/')
file.remove(test.sqlite)
}
