% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/editLink.R
\name{editLink}
\alias{editLink}
\title{Edit a link between two areas}
\usage{
editLink(
  from,
  to,
  hurdles_cost = NULL,
  transmission_capacities = NULL,
  asset_type = NULL,
  display_comments = NULL,
  filter_synthesis = NULL,
  filter_year_by_year = NULL,
  dataLink = NULL,
  tsLink = NULL,
  opts = antaresRead::simOptions()
)
}
\arguments{
\item{from, to}{The two areas linked together.}

\item{hurdles_cost}{Logical, which is used to state whether (linear)
transmission fees should be taken into account or not in economy and adequacy simulations}

\item{transmission_capacities}{Character, one of \code{enabled}, \code{ignore} or \code{infinite}, which is used to state whether
the capacities to consider are those indicated in 8760-hour arrays or
if zero or infinite values should be used instead (actual values / set to zero / set to infinite)}

\item{asset_type}{Character, one of \code{ac}, \code{dc}, \code{gas}, \code{virt} or \code{other}. Used to
state whether the link is either an AC component (subject to Kirchhoff’s laws), a DC component,
or another type of asset.}

\item{display_comments}{Logical, display comments or not.}

\item{filter_synthesis}{Output synthesis.}

\item{filter_year_by_year}{Output year-by-year.}

\item{dataLink}{See Details section below.}

\item{tsLink}{Transmission capacities time series. First N columns are direct TS, following N are indirect ones.}

\item{opts}{List of simulation parameters returned by the function
\code{\link[antaresRead:setSimulationPath]{antaresRead::setSimulationPath()}}}
}
\value{
An updated list containing various information about the simulation.
}
\description{
\ifelse{html}{\figure{badge_api_ok.svg}{options: alt='Antares API OK'}}{Antares API: \strong{OK}}

Edit a link between two areas in an Antares study.
}
\note{
See \code{\link[=createLink]{createLink()}} for more documentation
}
\examples{
\dontrun{
editLink(
  from = "area1",
  to = "area2",
  transmission_capacities = "infinite"
)
}
}
\seealso{
\code{\link[=createLink]{createLink()}}, \code{\link[=removeLink]{removeLink()}}
}
