% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copyToClipboard.R
\name{copyToClipboard}
\alias{copyToClipboard}
\alias{copyToClipboard.antaresDataList}
\title{Copy data to the clipboard}
\usage{
copyToClipboard(x, ...)

\method{copyToClipboard}{antaresDataList}(x, what, ...)
}
\arguments{
\item{x}{an object used to select a method.}

\item{...}{arguments passed to \code{\link{write.table}}}

\item{what}{character or numeric indicating which element to copy to clipboard (areas,
links, clusters or districts)}
}
\value{
The function does not return anything. It is only used to interact with the
clipboard
}
\description{
\code{copyToClipboard} is a utility function that copies data to the
clipboard. The data can then be copied in another program like excel.
}
\note{
The function is useful only for small data objects: for a table,
only the 50000 rows are copied to clipboard. If the table to copy
is longer, either use filters to reduce the number of rows or write the
table in text file with \code{\link{write.table}}
}
\examples{
 # This only works on Windows systems
\dontrun{
x <- data.frame(a = sample(10), b = sample(10))

copyToClipboard(x)

# Try to open excel and use CTRL + V to copy the data in a spreadsheet.
}

}
