% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuctionCapMethods.R
\docType{methods}
\name{AuctionCap-Methods}
\alias{AuctionCap-Methods}
\alias{calcBuyerExpectedCost}
\alias{calcBuyerValuation}
\alias{calcExpectedLowestCost}
\alias{calcExpectedPrice}
\alias{calcOptimalReserve}
\alias{calcSellerCostParms}
\alias{cdfG}
\alias{calcBuyerExpectedCost,Auction2ndCap-method}
\alias{calcBuyerValuation,Auction2ndCap-method}
\alias{calcExpectedLowestCost,Auction2ndCap-method}
\alias{calcExpectedPrice,Auction2ndCap-method}
\alias{calcOptimalReserve,Auction2ndCap-method}
\alias{calcSellerCostParms,Auction2ndCap-method}
\alias{cdfG,Auction2ndCap-method}
\title{Auction Cap Methods}
\usage{
\S4method{calcSellerCostParms}{Auction2ndCap}(object, ...)

\S4method{calcBuyerValuation}{Auction2ndCap}(object)

\S4method{calcOptimalReserve}{Auction2ndCap}(object, preMerger = TRUE,
  lower, upper)

\S4method{calcBuyerExpectedCost}{Auction2ndCap}(object, preMerger = TRUE)

\S4method{cdfG}{Auction2ndCap}(object, c, preMerger = TRUE)

\S4method{calcExpectedPrice}{Auction2ndCap}(object, preMerger = TRUE)

\S4method{calcExpectedLowestCost}{Auction2ndCap}(object,
  preMerger = TRUE)
}
\arguments{
\item{object}{An instance of the respective class (see description for the classes)}

\item{...}{Additional arguments to pass to \code{calcSellerCostParms}}

\item{preMerger}{If TRUE, the pre-merger ownership structure is used. If FALSE, the post-merger ownership structure is used.
Default is TRUE.}

\item{lower}{The minimum for the bidder's reserve price.}

\item{upper}{The maximum for the bidder's reserve price.}

\item{c}{\code{cdfG} calculates the probability that a cost draw less than or equal to
\sQuote{c} is realized for each firm. If \sQuote{c} is not supplied,
the buyer reserve and total capacity is used.}
}
\description{
\code{calcBuyerExpectedCost} computes the expected amount that the buyer will pay
    to the auction winner.

  \code{calcBuyerValuation} computes the value to the buyer of the outside option.

  \code{calcExpectedLowestCost} computes the expected lowest cost of the winning bid.

  \code{calcExpectedPrice} computes the expected price paid by the buyer.

  \code{calcOptimalReserve} computes the bidder's optimal reserve price.

  \code{calcSellerCostParms} calibrates the parameters of the Seller Cost
    CDF, as well as the reserve price, if not supplied.

  \code{cdfG} calculates the probability that a cost draw less than or equal to
    \sQuote{c} is realized for each firm. If \sQuote{c} is not supplied,
    the buyer reserve and total capacity is used.
}
\examples{
showMethods(classes="Auction2ndCap") # show all methods defined for the class

}
\author{
Charles Taragin \email{ctaragin@ftc.gov}
}
\keyword{methods}
