% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apaANOVATable1way.R
\name{apa.1way.table}
\alias{apa.1way.table}
\title{Creates a table of means and standard deviations for a 1-way ANOVA design in APA style}
\usage{
apa.1way.table(iv, dv, data, filename = NA, table.number = NA,
  show.conf.interval = FALSE, landscape = FALSE)
}
\arguments{
\item{iv}{Name of independent variable column in data frame}

\item{dv}{Name of dependent variable column in data frame}

\item{data}{Project data frame name}

\item{filename}{(optional) Output filename document filename (must end in .rtf or .doc only)}

\item{table.number}{Integer to use in table number output line}

\item{show.conf.interval}{(TRUE/FALSE) Display confidence intervals in table.}

\item{landscape}{(TRUE/FALSE) Make RTF file landscape}
}
\value{
APA table object
}
\description{
Creates a table of means and standard deviations for a 1-way ANOVA design in APA style
}
\examples{
# Example 1: 1-way from Field et al. (2012) Discovery Statistics Using R
apa.1way.table(iv=dose,dv=libido,data=viagra,filename="ex1_desc_table.doc")
}

