% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_queries.R
\name{sedona_range_query}
\alias{sedona_range_query}
\title{Execute a range query.}
\usage{
sedona_range_query(
  rdd,
  x,
  query_type = c("cover", "intersect"),
  index_type = c("quadtree", "rtree"),
  result_type = c("rdd", "sdf", "raw")
)
}
\arguments{
\item{rdd}{A Sedona spatial RDD.}

\item{x}{The query object.}

\item{query_type}{Type of spatial relationship involved in the query.
Currently "cover" and "intersect" are supported.}

\item{index_type}{Index to use to facilitate the KNN query. If NULL, then
do not build any additional spatial index on top of \code{x}. Supported
index types are "quadtree" and "rtree".}

\item{result_type}{Type of result to return.
If "rdd" (default), then the k nearest objects will be returned in a Sedona
spatial RDD.
If "sdf", then a Spark dataframe containing the k nearest objects will be
returned.
If "raw", then a list of k nearest objects will be returned. Each element
within this list will be a JVM object of type
\code{org.locationtech.jts.geom.Geometry}.}
}
\value{
The range query result.
}
\description{
Given a spatial RDD and a query object \code{x}, find all spatial objects
within the RDD that are covered by \code{x} or intersect \code{x}.
}
\examples{
library(sparklyr)
library(apache.sedona)

sc <- spark_connect(master = "spark://HOST:PORT")

if (!inherits(sc, "test_connection")) {
  range_query_min_x <- -87
  range_query_max_x <- -50
  range_query_min_y <- 34
  range_query_max_y <- 54
  geom_factory <- invoke_new(
    sc,
    "org.locationtech.jts.geom.GeometryFactory"
  )
  range_query_polygon <- invoke_new(
    sc,
    "org.locationtech.jts.geom.Envelope",
    range_query_min_x,
    range_query_max_x,
    range_query_min_y,
    range_query_max_y
  ) \%>\%
    invoke(geom_factory, "toGeometry", .)
  input_location <- "/dev/null" # replace it with the path to your input file
  rdd <- sedona_read_geojson_to_typed_rdd(
    sc,
    location = input_location,
    type = "polygon"
  )
  range_query_result_sdf <- sedona_range_query(
    rdd,
    x = range_query_polygon,
    query_type = "intersect",
    index_type = "rtree",
    result_type = "sdf"
  )
}

}
\seealso{
Other Sedona spatial query: 
\code{\link{sedona_knn_query}()}
}
\concept{Sedona spatial query}
