% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{sim_tree}
\alias{sim_tree}
\title{Random tree generation}
\usage{
sim_tree(n, edge.length = stats::runif)
}
\arguments{
\item{n}{Integer scalar. Number of leaf nodes.}

\item{edge.length}{A Function. Used to set the length of the edges.}
}
\value{
An object of class \link[ape:read.tree]{ape::phylo} with the edgelist as a postorderd,
\code{node.label} and \code{edge.length}.
}
\description{
An alternative to \link[ape:rtree]{ape::rtree}. This function was written in C++ and is
significantly faster than \code{rtree}.
}
\details{
The algorithm was implemented as follows

\enumerate{
\item Initialize \verb{N = \{1, ..., n\}}, \code{E} to be empty,
\code{k = 2*n - 1}
\item While \code{length(N) != 1} do:
\enumerate{
\item Randomly choose a pair \verb{(i, j)} from \code{N}
\item Add the edges \verb{E = E U \{(k, i), (k, j)\}},
\item Redefine \verb{N = (N \\ \{i, j\}) U \{k\}}
\item Set \code{k = k - 1}
\item next
}
\item Use \code{edge.length(2*n - 1)} (simulating branch lengths).
}
}
\examples{
# A very simple example ----------------------------------------------------
set.seed(1223)
newtree <- sim_tree(50)

plot(newtree)


# A performance benchmark with ape::rtree ----------------------------------
\dontrun{
library(ape)
microbenchmark::microbenchmark(
  ape = rtree(1e3),
  phy = sim_tree(1e3),
 unit = "relative"
)
# This is what you would get.
# Unit: relative
#   expr     min       lq     mean  median       uq      max neval
#    ape 14.7598 14.30809 14.30013 16.7217 14.32843 4.754106   100
#    phy  1.0000  1.00000  1.00000  1.0000  1.00000 1.000000   100
}
}
