% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_estimate.R
\name{apollo_estimate}
\alias{apollo_estimate}
\title{Estimates model}
\usage{
apollo_estimate(apollo_beta, apollo_beta_fixed, database,
  apollo_probabilities, apollo_control, apollo_draws = NA,
  apollo_randcoeff = NA, apollo_lcpars = NA, HB_control = NA,
  estimation_routine = "bfgs", max_iterations = 200,
  work_in_logs = FALSE, numDerivHessian = TRUE, printLevel = 3L,
  silent = FALSE)
}
\arguments{
\item{apollo_beta}{Named numeric vector. Names and starting values for parameters}

\item{apollo_beta_fixed}{Character vector. Names of parameters to be fixed at starting values.}

\item{database}{data.frame. Data used by model.}

\item{apollo_probabilities}{Function. Returns probabilities of the model to be estimated. Must receive seven arguments:
\describe{
  \item{apollo_beta}{Named numeric vector. Names and values of model parameters.}
  \item{database}{Same as described above.}
  \item{apollo_control}{Same as described below.}
  \item{draws}{Same as described below. Optional. NA by default.}
  \item{apollo_randcoeff}{Same as described below. NA by default.}
  \item{functionality}{Character. Can be either "estimate" (default), "prediction", "validate", "conditionals", "zero_LL", or "raw".}
  \item{work_in_logs}{Same as described below. FALSE by default.}
}}

\item{apollo_control}{List. Options controlling the running of the code.
\describe{
  \item{modelName}{Character. Name of the model. Used when saving the output to files.}
  \item{modelDescr}{Character. Description of the model. Used in output files.}
  \item{indivID}{Character. Name of column in the database with each decision maker's ID.}
  \item{mixing}{Boolean. TRUE for models that include random parameters.}
  \item{nCores}{Numeric>0. Number of cores to use in calculations of the model likelihood.}
  \item{seed}{Numeric. Seed for random number generation.}
  \item{HB}{Boolean. TRUE if using RSGHB for Bayesian estimation of model.}
  \item{noValidation}{Boolean. TRUE if user does not wish model input to be validated before estimation - FALSE by default.}
  \item{noDiagnostics}{Boolean. TRUE if user does not wish model diagnostics to be printed - FALSE by default.}
  \item{panel}{Boolean. TRUE if using panel data (created automatically by \code{apollo_validatecontrol)}}
}}

\item{apollo_draws}{List of arguments describing the inter and intra individual draws.
\describe{
  \item{inter_drawsType}{Character. Type of inter-individual draws ('MLHS', 'halton' or 'pmc').}
  \item{inter_nDraws}{Numeric scalar (>=0). Number of inter-individual draws per individual. Set to 0 if not using them.}
  \item{inter_unifDraws}{Character vector. Names of uniform-distributed inter-individual draws.}
  \item{inter_normDraws}{Character vector. Names of normaly distributed inter-individual draws.}
  \item{intra_drawsType}{Character. Type of intra-individual draws ('MLHS', 'halton' or 'pmc').}
  \item{intra_nDraws}{Numeric scalar (>=0). Number of intra-individual draws per individual. Set to 0 if not using them.}
  \item{intra_unifDraws}{Character vector. Names of uniform-distributed intra-individual draws.}
  \item{intra_normDraws}{Character vector. Names of normaly distributed intra-individual draws.}
}}

\item{apollo_randcoeff}{Function. Used with mixing models. Constructs the random parameters of a mixing model. Receives two arguments:
\describe{
  \item{apollo_beta}{Same as described above}
  \item{draws}{Same as described above}
}
Takes value NA if omitted. Required for models with mixing.}

\item{apollo_lcpars}{Function. Used with latent class models. Constructs a list of parameters for each latent class. Receives two arguments:
\describe{
  \item{apollo_beta}{Same as described above}
  \item{randcoeff}{The output of function \code{apollo_randcoeff}, as described above.
                   If the model does not contain mixing, then defaults to \code{NA}.}
}
Takes value NA if omitted. Required for models with mixing.}

\item{HB_control}{List. Contains options for bayesian estimation. Required if \code{apollo_control$HB} is TRUE.}

\item{estimation_routine}{Character. Estimation method. Can take values "bfgs" (recommended), "bhhh", or "nr".
Used only if \code{apollo_control$HB} is FALSE.}

\item{max_iterations}{Numeric. Maximum number of iterations of the search algorithm before stopping.
Used only if \code{apollo_control$HB} is FALSE.}

\item{work_in_logs}{Boolean. TRUE for higher numeric stability at the expense of computational time. Useful for panel models only. Default is FALSE.}

\item{numDerivHessian}{Boolean. Determines the R package used to calculate the Hessian after estimation. If TRUE, the code{numDeriv}
package is used. If FALSE, the code{maxLik} package is used. Only used if \code{apollo_control$HB=FALSE}. Default is TRUE.}

\item{printLevel}{Numeric scalar. Can take integer values 0, 1, 2 or 3. The higher the number the more information is printed during estimation.
Ignored if apollo_control$HB is TRUE. Default value is 3.}

\item{silent}{Boolean. If TRUE, no information is printed to console during estimation. Default is FALSE.}
}
\value{
model object
}
\description{
Estimates a model using the likelihood function defined by \code{apollo_probabilities}.
}
\details{
This is the main function of the cmcRcode package. The estimation process begins by checking the definition of
\code{apollo_probabilities} by estimating it at the starting values. Then it runs the function with argument \code{functionality="validate"}.
If the user requested more than one core for estimation (i.e. \code{apollo_control$nCores>1}), and no bayesian estimation is used
(i.e. \code{apollo_control$HB=FALSE}), then a cluster is created. Using a cluster at least doubles the requires RAM, as the database
must be copied into the cluster.
If all checks are passed, estimation begins. There is no limit to estimation time other than reaching the maximum number of
iterations. If bayesian estimation is used, estimation will finish once the predefined number of draws are completed.
This functions does not save results into a file nor prints them into the console, so if users want to see and store estimation the results,
they must make sure to call function \code{apollo_modeloutput} and \code{apollo_saveoutput} afterwards.
}
\examples{
### Set core controls
apollo_control = list(
  modelName ="MNL", # Make sure to use a new name for every model
  indivID   ="ID",  # Name of column in the database with each individual's ID
  mixing    = FALSE,# TRUE for models that include random parameters
  nCores    = 1     # Number of cores to use in estimation
)

### Load data
data(apollo_modeChoiceData)

### Model parameters
apollo_beta = c(asc_1=0, asc_2=0,
                asc_3=0, asc_4=0,
                tt   =0, tc   =0,
                acc  =0)

### Name of parameters fixed to starting values.
apollo_beta_fixed = c("asc_2")

### Likelihood function (do not change the arguments)
### b contains the parameters, x contains the explanatory variables
apollo_probabilities=function(b, x, functionality="estimate"){
  P <- list() ### Do not delete. Store probabilities here.

  ### Enumerate alternatives and availability, and select choice variable.
  alternatives = c(car=1, bus=2, air=3, rail=4)
  avail        = list(car=x$av_car, bus=x$av_bus, air=x$av_air, rail=x$av_rail)
  choiceVar    = x$choice

  ### List of utilities
  V = list()
  V[['car' ]] = b$asc_1 + b$tt*x$time_car  + b$tc*x$cost_car
  V[['bus' ]] = b$asc_2 + b$tt*x$time_bus  + b$tc*x$cost_bus  + b$acc*x$access_bus
  V[['air' ]] = b$asc_3 + b$tt*x$time_air  + b$tc*x$cost_air  + b$acc*x$access_air
  V[['rail']] = b$asc_4 + b$tt*x$time_rail + b$tc*x$cost_rail + b$acc*x$access_rail

  ### Compute choice probabilities using MNL model
  P[['model']] = apollo_mnl(alternatives, avail, choiceVar, V, functionality)

  return(P)
}

### Estimate model
model = apollo_estimate(apollo_beta, apollo_beta_fixed, database,
                        apollo_probabilities, apollo_control)

### Show output in screen
apollo_modeloutput(model)

}
