% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{contrasts_summary}
\alias{contrasts_summary}
\alias{contrasts_summary.default}
\alias{contrasts_summary.merMod}
\alias{contrasts_summary.glmerMod}
\title{Summary for hypr contrasts}
\usage{
contrasts_summary(model, ...)

\method{contrasts_summary}{default}(model, ...)

\method{contrasts_summary}{merMod}(model, ...)

\method{contrasts_summary}{glmerMod}(model, ...)
}
\arguments{
\item{model}{a model of class \code{\link[stats]{lm}}, \code{\link[stats]{glm}}
or \code{\link[lme4]{lmer}}.}

\item{...}{additional options (not used at the moment)}
}
\value{
A results table of class \code{hypr_contrasts_results}.
}
\description{
Extract the estimates and the inferential tests for a contrasts
defined by \code{\link[hypr]{hypr}}
}
\examples{
 library(MASS)
 df<-MASS::anorexia
 df$Treat = factor(df$Treat)
 library ( hypr )
 h <- hypr ( ~ 1/2 * CBT + 1/2 * FT - Cont , ~ CBT - FT , levels = c( "CBT" , "Cont" , "FT" ))
 contrasts(df$Treat,how.many=2)<-cmat(h)
 model = lm ( Prewt ~ Treat , data = df )
 contrasts_summary ( model )



}
