% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml.shrink.R
\name{ml.shrink}
\alias{ml.shrink}
\title{Estimation of a Shrinkage Factor for Logistic Regression}
\usage{
ml.shrink(b, dat)
}
\arguments{
\item{b}{1 x \code{m} matrix of regression coefficients, derived by resampling or
sample-splitting}

\item{dat}{a \code{p} x \code{m} data matrix, where the final column is a
binary outcome variable. This dataset acts as a "test set" or "validation set".}
}
\value{
the function returns a single shrinkage factor
}
\description{
Estimate a shrinkage factor for shrinkage-after-estimation techniques,
with application to logistic regression models.
}
\details{
This function works together with \code{\link{bootval}}, \code{\link{splitval}},
\code{\link{kcrossval}} and \code{\link{loocval}} to estimate a shrinkage factor. For further details,
see References. This function should not be used directly, and instead should
be called via one of the aforementioned shrinkage-after-estimation functions.
}
\note{
Currently, this function can only derive a single shrinkage factor for a given
model, and is unable to estimate (weighted) predictor-specific shrinkage factors.
}
\references{
Harrell, F. E. \emph{"Regression modeling strategies: with applications
             to linear models, logistic regression, and survival analysis."} \emph{Springer}, (2001).

Steyerberg, E. W. \emph{"Clinical Prediction Models", Springer} (2009)
}

