% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dice.R
\name{dice}
\alias{dice}
\title{Efficient Slicing of \code{SoilProfileCollection} Objects}
\usage{
dice(
  x,
  fm = NULL,
  SPC = TRUE,
  pctMissing = FALSE,
  fill = FALSE,
  strict = TRUE,
  byhz = FALSE
)
}
\arguments{
\item{x}{a \code{SoilProfileCollection} object}

\item{fm}{optional \code{formula} describing top depths and horizon level attributes to include: \code{integer.vector ~ var1 + var2 + var3} or \code{integer.vector ~ .} to include all horizon level attributes. When \code{NULL} profiles are "diced" to depth and results will include all horizon level attributes.}

\item{SPC}{return the diced \code{SoilPrfolileCollection}, if \code{FALSE} a \code{data.frame} of horizon-level attributes}

\item{pctMissing}{compute "percent missing data" by slice (when \code{TRUE} expect 6-8x longer run time)}

\item{fill}{logical, fill with empty placeholder horizons in gaps within profiles, and/or, above/below interval specified in \code{fm}. Automatically set to \code{TRUE} when \code{fm} is specified. Backwards compatibility with \code{slice} is maintained by setting \code{fill = TRUE} with or without \code{fm}.}

\item{strict}{perform horizon depth logic checking / flagging / removal}

\item{byhz}{Evaluate horizon depth logic at the horizon level (\code{TRUE}) or profile level (\code{FALSE}). Invalid depth logic invokes \code{HzDepthLogicSubset} which removes offending profiles or horizon records.}
}
\value{
a \code{SoilProfileCollection} object, or \code{data.frame} when \code{SPC = FALSE}
}
\description{
Cut ("dice") soil horizons into 1-unit thick slices. This function will eventually replace \code{aqp::slice()}.
}
\details{
For large and potentially messy collections that include missing horizon bottom depths, or 0-thickness horions, consider using \code{repairMissingHzDepths()} before \code{dice()}.
}
\author{
D.E. Beaudette, A.G. Brown
}
