% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glom.R
\name{glom,SoilProfileCollection-method}
\alias{glom,SoilProfileCollection-method}
\alias{glom}
\title{Subset soil horizon data using a depth or depth interval}
\usage{
\S4method{glom}{SoilProfileCollection}(
  p,
  z1,
  z2 = NULL,
  ids = FALSE,
  df = FALSE,
  truncate = FALSE,
  invert = FALSE,
  fill = FALSE,
  modality = "all"
)
}
\arguments{
\item{p}{a SoilProfileCollection}

\item{z1}{numeric vector of top depth to intersect horizon (required). Can be an expression involving \code{siteNames(p)} or quoted column name. Should evaluate to numeric length \code{1} or length equal to \code{length(p)}}

\item{z2}{numeric vector bottom depth of intersection interval (optional). Can also be an expression involving \code{siteNames(p)} or quoted column name. Should evaluate to numeric length \code{1}, length equal to \code{length(p)} or \code{NULL}. Default: \code{NULL} is "point" intersection}

\item{ids}{return only horizon IDs? default: \code{FALSE}}

\item{df}{return a data.frame, by intersection with \code{horizons(p)}? default: \code{FALSE}}

\item{truncate}{truncate horizon top and bottom depths to \code{z1} and \code{z2}? default: \code{FALSE}}

\item{invert}{get horizons \emph{outside} the interval \verb{[z1,z2]}? default: \code{FALSE}}

\item{fill}{keep sites and preserve order for profiles that do not have horizons in interval by filling with a single horizon with \code{NA} top and bottom depth. default: \code{FALSE}}

\item{modality}{default: \code{"all"} return all horizons; or \code{modality = "thickest"}) to return the \emph{thickest} horizon in interval. If multiple horizons have equal thickness, the first (shallowest) is returned.}
}
\value{
a SoilProfileCollection, data.frame, or a vector of horizon IDs. \code{NULL} if no result.
}
\description{
Make a "clod" of horizons from a SoilProfileCollection given a point or a depth interval to intersect. The interval \verb{[z1,z2]} may be profile-specific (equal in length to \code{p}), or may be recycled over all profiles (if boundaries are length 1). For "point" intersection, \code{z2} may be left as the default value \code{NULL}.
}
\details{
"To glom" is "to steal" or to "become stuck or attached to". The word is related to the compound "glomalin", which is a glycoprotein produced by mycorrhizal fungi in soil.

The full depth range of horizons included within the interval are returned (a "ragged" SoilProfileCollection) unless the \code{truncate} argument is set as \code{TRUE}. Horizon intersection is based on unique ID \code{hzidname(spc)} and depth range of interest. Profiles that lack data in the range of interest will be dropped from the resulting SoilProfileCollection.

If inverting results with \code{invert}, it is possible that thick horizons (whose boundaries span wider than the specified interval) will be split into \emph{two} horizons, where previously they were one. This may make the results from \code{ids = TRUE} different from what you expect, as they will be based on a profile with an "extra" horizon and re-calculated unique horizon ID (\code{hzidname(spc)}) \code{"hzID"}.
}
\examples{
data(sp1, package = 'aqp')
depths(sp1) <- id ~ top + bottom
site(sp1) <- ~ group

p <- glom(sp1, 25, 150)

# 28 horizons
nrow(p) 

# inspect graphically
par(mar = c(1,1,3,1))
plot(p, color = "prop", max.depth = 200)
abline(h = c(25, 100), lty = 2)

## glom(..., truncate = TRUE)

p2 <- glom(sp1, 25, 150, truncate = TRUE)

# 28 horizons
nrow(p2) 

# inspect graphically
par(mar = c(1,1,3,1))
plot(p2, color = "prop", max.depth = 200)
abline(h = c(25, 100), lty = 2)

## glom(..., truncate = TRUE, invert = TRUE)

p3 <- glom(sp1, 25, 150, truncate = TRUE, invert = TRUE)

# 45 horizons
nrow(p3) 

# inspect graphically
par(mar = c(1,1,3,1))
plot(p3, color = "prop", max.depth = 200)
abline(h = c(25, 100), lty = 2)

## profile-specific interval, using expressions evaluated within sp1@site

# calculate some new site-level variables containing target interval
sp1$glom_top <- (1:9) * 10
sp1$glom_bottom <- 10 + sp1$glom_top

# glom evaluates non-standard expressions using siteNames(sp1) column names
p4 <- glom(sp1, glom_top / 2, glom_bottom * 1.2, truncate = TRUE)

# inspect graphically
par(mar = c(1,1,3,1))
plot(p4, color = "prop", max.depth = 200)

}
\seealso{
\code{\link{glomApply}} \code{\link{trunc}}
}
\author{
Andrew G. Brown
}
