% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profileInformationIndex.R
\name{profileInformationIndex}
\alias{profileInformationIndex}
\title{Soil Profile Information Index}
\usage{
profileInformationIndex(
  x,
  vars,
  method = c("median", "mean", "sum"),
  baseline = TRUE,
  useDepths = TRUE,
  numericDigits = 4
)
}
\arguments{
\item{x}{\code{SoilProfileCollection} object}

\item{vars}{character vector of site or horizon level attributes to consider}

\item{method}{character: aggregation method, information content evaluated over \code{vars}: 'median', 'mean', or 'sum'}

\item{baseline}{logical, compute ratio to "baseline" information content, see details}

\item{useDepths}{logical, include horizon depths in \code{vars}}

\item{numericDigits}{integer, number of significant digits to retain in numeric -> character conversion}
}
\value{
a numeric vector of the same length as \code{length(x)} and in the same order, suitable for direct assignment to a new site-level attribute
}
\description{
A simple index of "information" content associated with individuals in a \code{SoilProfileCollection} object. Information content is quantified by number of bytes after gzip compression via \code{memCompress()}.
}
\details{
Information content via compression (gzip) is the central assumption behind this function: the values associated with a simple soil profile having few horizons and little variation between horizons (isotropic depth-functions) will compress to a much smaller size than a complex profile (many horizons, strong anisotropy). Information content is evaluated a profile at a time, over each site or horizon level attribute specified in \code{vars}. Values are aggregated to the profile level by \code{method}: median, mean, or sum. The \code{baseline} argument invokes a comparison to the simplest possible representation of each depth-function:
\itemize{
\item \code{numeric}: replication of the mean value to match the number of horizons with non-NA values
\item \code{character} or \code{factor}: replication of the most frequent value to match the number of horizons with non-NA values
}

The ratios computed against a "simple" baseline represent something like "information gain", ranging from 0 to 1. Larger baseline ratios suggest more complexity (more information) associated with a soil profile's depth-functions. Alternatively, the total quantity of information (in bytes) can be determined by setting \code{baseline = FALSE} and \code{method = 'sum'}.
}
\author{
D.E. Beaudette
}
