% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-batch-geocode.R
\name{geocode_addresses}
\alias{geocode_addresses}
\title{Batch Geocode Addresses}
\usage{
geocode_addresses(
  single_line = NULL,
  address = NULL,
  address2 = NULL,
  address3 = NULL,
  neighborhood = NULL,
  city = NULL,
  subregion = NULL,
  region = NULL,
  postal = NULL,
  postal_ext = NULL,
  country_code = NULL,
  location = NULL,
  search_extent = NULL,
  category = NULL,
  crs = NULL,
  max_locations = NULL,
  for_storage = FALSE,
  match_out_of_range = NULL,
  location_type = NULL,
  lang_code = NULL,
  source_country = NULL,
  preferred_label_values = NULL,
  batch_size = NULL,
  geocoder = default_geocoder(),
  token = arc_token(),
  .progress = TRUE
)
}
\arguments{
\item{single_line}{a character vector of addresses to geocode. If provided
other \code{address} fields cannot be used. If \code{address} is not provided,
\code{single_line} must be.}

\item{address}{a character vector of the first part of a street address.
Typically used for the street name and house number. But can also be a place
or building name. If \code{single_line} is not provided, \code{address} must be.}

\item{address2}{a character vector of the second part of a street address.
Typically includes a house number, sub-unit, street, building, or place name.
Optional.}

\item{address3}{a character vector of the third part of an address. Optional.}

\item{neighborhood}{a character vector of the smallest administrative division
associated with an address. Typically, a neighborhood or a section of a
larger populated place. Optional.}

\item{city}{a character vector of the next largest administrative division
associated with an address, typically, a city or municipality. A city is a
subdivision of a subregion or a region. Optional.}

\item{subregion}{a character vector of the next largest administrative division
associated with an address. Depending on the country, a subregion can
represent a county, state, or province. Optional.}

\item{region}{a character vector of the largest administrative division
associated with an address, typically, a state or province. Optional.}

\item{postal}{a character vector of the standard postal code for an address,
typically, a three– to six-digit alphanumeric code. Optional.}

\item{postal_ext}{a character vector of the postal code extension, such as
the United States Postal Service ZIP+4 code, provides finer resolution or
higher accuracy when also passing postal. Optional.}

\item{country_code}{default \code{NULL.} An ISO 3166 country code.
See \code{\link[=iso_3166_codes]{iso_3166_codes()}} for valid ISO codes. Optional.}

\item{location}{an \code{sfc_POINT} object that centers the search. Optional.}

\item{search_extent}{an object of class \code{bbox} that limits the search area. This is especially useful for applications in which a user will search for places and addresses within the current map extent. Optional.}

\item{category}{a scalar character. Place or address type that can be used to
filter suggest results. Optional.}

\item{crs}{the CRS of the returned geometries. Passed to \code{sf::st_crs()}.
Ignored if \code{locations} is not an \code{sfc_POINT} object.}

\item{max_locations}{the maximum number of results to return. The default is
15 with a maximum of 50. Optional.}

\item{for_storage}{default \code{FALSE}. Whether or not the results will be saved
for long term storage.}

\item{match_out_of_range}{set to \code{TRUE} by service by default. Matches locations Optional.}

\item{location_type}{default \code{"rooftop"}. Must be one of \code{"rooftop"} or \code{"street"}.
Optional.}

\item{lang_code}{default \code{NULL}. An ISO 3166 country code.
See \code{\link[=iso_3166_codes]{iso_3166_codes()}} for valid ISO codes. Optional.}

\item{source_country}{default \code{NULL}. An ISO 3166 country code.
See \code{\link[=iso_3166_codes]{iso_3166_codes()}} for valid ISO codes. Optional.}

\item{preferred_label_values}{default NULL. Must be one of \code{"postalCity"}
or \code{"localCity"}. Optional.}

\item{batch_size}{the number of addresses to geocode per
request. Uses the suggested batch size property of the
\code{geocoder}.}

\item{geocoder}{default \code{\link[=default_geocoder]{default_geocoder()}}.}

\item{token}{an object of class \code{httr2_token} as generated by \code{\link[arcgisutils:auth_code]{auth_code()}}
or related function}

\item{.progress}{default \code{TRUE}. Whether a progress bar should be provided.}
}
\value{
an \code{sf} object
}
\description{
Gecocode a vector of addresses in batches.
}
\details{
Addresses are partitioned into batches of up to \code{batch_size}
elements. The batches are then sent to the geocoding service
in parallel using \code{\link[httr2:req_perform_parallel]{httr2::req_perform_parallel()}}.
The JSON responses are then processed
using Rust and returned as an sf object.

Utilizes the \href{https://developers.arcgis.com/rest/geocode/api-reference/geocoding-geocode-addresses.htm}{\verb{/geocodeAddresses}} endpoint.
}
\examples{
# Example dataset from the Urban Institute
\dontrun{
fp <- paste0(
  "https://urban-data-catalog.s3.amazonaws.com/",
  "drupal-root-live/2020/02/25/geocoding_test_data.csv"
)
to_geocode <- read.csv(fp)
geocode_addresses(
  address = to_geocode$address,
  city = to_geocode$city,
  region = to_geocode$state,
  postal = to_geocode$zip
)
}
}
