% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/midnight_to_midnight.R
\name{midnight_to_midnight}
\alias{midnight_to_midnight}
\title{Expand activity data vector into midnight-to-midnight format}
\usage{
midnight_to_midnight(acc, acc_ts)
}
\arguments{
\item{acc}{A numeric vector. A minute-level activity counts data vector.}

\item{acc_ts}{A POSIXct vector. Time of activity data collection, corresponding to
\code{acc}. We strongly recommended to use \code{lubridate::ymd_hms()} function to create \code{acc_ts} (see Examples below).}
}
\value{
A numeric vector. A minute-level activity counts data vector in
midnight-to-midnight format.
}
\description{
Expand activity data vector such that its length is
a multiple of number of minutes in a full day (1440).
}
\details{
In the returned vector,
1st observation
corresponds to minute of 00:00-00:01 on the first day of data collection,
and last observation
corresponds to minute of 23:59-00:00 on the last day of data collection.
Entries corresponding to no data in original activity data vector
are filled with \code{NA}.
}
\examples{
## Read exemplary data
fpath_i <- system.file("extdata", extdata_fnames[1], package = "arctools")
dat_i   <- as.data.frame(data.table::fread(fpath_i))
acc     <- dat_i$vectormagnitude
acc_ts  <- lubridate::ymd_hms(dat_i$timestamp)
## Get acc data vector in "midnight_to_midnight" format
acc <- midnight_to_midnight(acc, acc_ts)
## Observe we have an integer number of days
length(acc) / 1440

}
