% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/subset.R
\docType{methods}
\name{subset}
\alias{subset}
\alias{[,AbundanceMatrix-method}
\alias{[<-,AbundanceMatrix-method}
\alias{[[<-,AbundanceMatrix-method}
\title{Extract or Replace Parts of an Object}
\usage{
\S4method{[}{AbundanceMatrix}(x, i, j, ..., drop = TRUE)

\S4method{[}{AbundanceMatrix}(x, i, j, ...) <- value

\S4method{[[}{AbundanceMatrix}(x, i, j, ...) <- value
}
\arguments{
\item{x}{An object from which to extract element(s) or in which to replace
element(s) (typically a \verb{*Matrix} object).}

\item{i, j}{Indices specifying elements to extract or replace. Indices are
\code{\link{numeric}}, \code{\link{integer}} or \code{\link{character}} vectors or empty (missing) or
\code{NULL}. Numeric values are coerced to \code{\link{integer}} as by \code{\link[=as.integer]{as.integer()}}
(and hence truncated towards zero). Character vectors will be matched to
the name of the elements. An empty index (a comma separated blank) indicates
that all entries in that dimension are selected.}

\item{...}{Currently not used.}

\item{drop}{A \code{\link{logical}} scalar: should the result be coerced to
the lowest possible dimension? This only works for extracting elements,
not for the replacement.}

\item{value}{A possible value for the element(s) of \code{x}.}
}
\value{
A subsetted object of the same sort as \code{x}.
}
\description{
Operators acting on objects to extract or replace parts.
}
\examples{
## Create an incidence (presence/absence) matrix
## Data will be coerced with as.logical()
A <- IncidenceMatrix(data = sample(0:1, 100, TRUE, c(1, 1/3)), nrow = 20)
## Create a count data matrix
B <- CountMatrix(data = sample(0:10, 100, TRUE), nrow = 20)

## Access
dim(B) # Get the matrix dimensions
row(B) # Get the row indexes
col(B, as.factor = TRUE) # Get the column indexes
nrow(B) # Get the number of rows
ncol(B) # Get the number of columns
dimnames(B) # Get the dimension names
rownames(B) <- LETTERS[1:20] # Set the row names
rownames(B) # Get the rownames
colnames(B) <- letters[21:25] # Set the column names
colnames(B) # Get the column names

## Subset
B[[1, 1]] # Get the first value
B[1] # Get the first value
B[, ] # Get all values
B[1, , drop = FALSE] # Get the first row
B[, 1:3] # Get the first three column
}
\seealso{
Other mutators: 
\code{\link{mutators}},
\code{\link{summary}()}
}
\author{
N. Frerebeau
}
\concept{mutators}
