% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/statistics.R
\docType{methods}
\name{interval_hdr}
\alias{interval_hdr}
\alias{interval_hdr-method}
\alias{interval_hdr,numeric,numeric-method}
\alias{interval_hdr,numeric,missing-method}
\title{Highest Density Regions}
\usage{
interval_hdr(x, y, ...)

\S4method{interval_hdr}{numeric,numeric}(x, y, level = 0.954)

\S4method{interval_hdr}{numeric,missing}(x, level = 0.954, ...)
}
\arguments{
\item{x}{A \code{\link{numeric}} vector giving the coordinates of the points where
the density is estimated.}

\item{y}{A \code{\link{numeric}} vector giving the estimated density values.
If \code{y} is missing and \code{x} is a \code{numeric} vector, density estimates will be
computed from \code{x}.}

\item{...}{Further arguments to be passed to \code{\link[stats:density]{stats::density()}}.}

\item{level}{A length-one \code{\link{numeric}} vector giving the confidence level.}
}
\value{
A three-columns \code{numeric} \code{\link{matrix}} giving the lower and upper boundaries
of the HPD interval and associated probabilities.
}
\description{
Highest Density Regions
}
\examples{
## HDR of the Old Faithful eruption times
interval_hdr(faithful$eruptions)
}
\references{
Hyndman, R. J. (1996). Computing and graphing highest density regions.
\emph{American Statistician}, 50: 120-126. \doi{10.2307/2684423}.
}
\seealso{
Other summary statistics: 
\code{\link{confidence_binomial}()},
\code{\link{confidence_mean}()},
\code{\link{confidence_multinomial}()},
\code{\link{interval_credible}()}
}
\author{
N. Frerebeau
}
\concept{summary statistics}
