% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compositions.R
\name{ncompositions}
\alias{ncompositions}
\title{Number of compositions}
\usage{
ncompositions(n, k = NULL, bigz = FALSE)
}
\arguments{
\item{n}{an non-negative integer to be partitioned}

\item{k}{number of parts}

\item{bigz}{an logical to use \link[gmp:bigz]{gmp::bigz}}
}
\description{
Number of compositions
}
\examples{
# number of compositions of 10
ncompositions(10)
# number of compositions of 10 into 5 parts
ncompositions(10, 5)

# integer overflow
\dontrun{ncompositions(160)}
ncompositions(160, bigz = TRUE)

# zero sized compositions
ncompositions(0)
ncompositions(5, 0)
ncompositions(5, 6)
ncompositions(0, 0)
ncompositions(0, 1)
}
\seealso{
\link{compositions} for generating all compositions and \link{icompositions} for iterating compositions
}
