% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.modelsum.R
\name{as.data.frame.modelsum}
\alias{as.data.frame.modelsum}
\title{as.data.frame.modelsum}
\usage{
\method{as.data.frame}{modelsum}(x, ..., title = NULL,
  labelTranslations = NULL, digits = NA, nsmall = NA, nsmall.ratio = NA,
  digits.test = NA, show.intercept = NA, show.adjust = NA,
  pFootnote = TRUE)
}
\arguments{
\item{x}{An object of class \code{\link{modelsum}}.}

\item{...}{Other arguments (not implemented a this time).}

\item{title}{Title for the table, defaults to \code{NULL} (no title)}

\item{labelTranslations}{A named list (or vector) where the name is the label in the
output to be replaced in the pretty rendering of modelsum by the character
string value for the named element of the list, e.g., 
\code{list(age = "Age(years)", medsurv = "Median Survival")}. This applies to the statistic
labels and the variable labels in the output.}

\item{digits}{Maximum number of digits to display for floating point numbers.
If \code{NA} (default), it uses the value from \code{object$control$digits}
(whose default is 3, which would result in, e.g., 12.3, 1.23, 0.123, and 0.012).}

\item{nsmall}{Minimum number of digits to the right of the decimal point to display for
floating point numbers.  If \code{NA} (default), it uses the value from \code{object$control$nsmall}.
Allowed non-\code{NA} values are \code{0 <= nsmall <= 20}.}

\item{nsmall.ratio}{Minimum number of digits to the right of the decimal point to display
for the ratio statistics (OR, HR, RR). If \code{NA} (default) it uses the value from
\code{object$control$nsmall.ratio} (whose default is 2).
Allowed values are \code{0 <= nsmall.ratio <= 20}.}

\item{digits.test}{Number of digits to display for a p-value. Default is 5 (e.g. 0.12345).}

\item{show.intercept}{Logical, denoting if the intercept should be shown for each line}

\item{show.adjust}{Logical, denoting if the adjust variables should be shown for each line.}

\item{pFootnote}{Logical denoting if a footnote should be added describing the test used
to generate the p value.  Default is \code{TRUE}.}
}
\value{
A data.frame holding the modelsum
}
\description{
Build a data.frame from the modelsum object and parameters, and return it
}
\author{
Greg Dougherty
}
