% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arsenal_table.R
\name{arsenal_table}
\alias{arsenal_table}
\alias{has_strata}
\alias{[.arsenal_table}
\alias{labels.arsenal_table}
\alias{labels<-.arsenal_table}
\alias{print.arsenal_table}
\alias{merge.arsenal_table}
\alias{merge.freqlist}
\alias{print.summary.arsenal_table}
\title{\code{arsenal} tables with common structure}
\usage{
has_strata(x)

\method{[}{arsenal_table}(x, i, j, ...)

\method{labels}{arsenal_table}(object, ...)

\method{labels}{arsenal_table}(x) <- value

\method{print}{arsenal_table}(x, ...)

\method{merge}{arsenal_table}(x, y, all = FALSE, all.x = all,
  all.y = all, ...)

\method{merge}{freqlist}(x, y, all = TRUE, ...)

\method{print}{summary.arsenal_table}(x, ..., format = if
  (!is.null(x$text) && x$text \%in\% c("html", "latex")) x$text else
  "markdown", escape = x$text \%nin\% c("html", "latex"), width = NULL,
  min.split = NULL)
}
\arguments{
\item{x, y, object}{An object of class \code{"arsenal_table"}}

\item{i, j}{A vector to index \code{x} with: either names of variables, a numeric vector, or a logical vector of appropriate length.
\code{i} indexes the x-variables, and \code{j} indexes the by-variables.}

\item{...}{Other arguments (only used in \code{print.summary.arsenal_table})}

\item{value}{A list of new labels.}

\item{all, all.x, all.y}{Logicals, denoting which terms to keep if not all are in common.}

\item{format}{Passed to \code{\link[knitr]{kable}}: the format for the table. The default here is "markdown".
To use the default in \code{kable}, pass \code{NULL}. If \code{x$text} specifies LaTeX or HTML formatting,
that format is used in the table.}

\item{escape}{Passed to \code{\link[knitr]{kable}}: should special characters be escaped when printed?}

\item{width, min.split}{Passed to \code{\link{smart.split}} for formatting of the "term" column.}
}
\description{
\code{arsenal} tables with common structure
}
\seealso{
\code{\link{merge}}, \code{\link{labels}}
}
