// Generated by rstantools.  Do not edit by hand.

/*
    artemis is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    artemis is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with artemis.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_eDNA_sim_omni_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_eDNA_sim_omni");
    reader.add_event(88, 86, "end", "model_eDNA_sim_omni");
    return reader;
}
#include <stan_meta_header.hpp>
class model_eDNA_sim_omni
  : public stan::model::model_base_crtp<model_eDNA_sim_omni> {
private:
        int N;
        int n_vars;
        int n_rand;
        int n_grp;
        matrix_d X;
        int has_random;
        std::vector<int> groups;
        matrix_d rand_x;
        vector_d rand_sigma;
        std::vector<double> std_curve_alpha;
        std::vector<double> std_curve_beta;
        double upper_Cq;
        double p_zero;
        double sigma_ln_eDNA;
        vector_d betas;
public:
    model_eDNA_sim_omni(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_eDNA_sim_omni(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_eDNA_sim_omni_namespace::model_eDNA_sim_omni";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 22;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            current_statement_begin__ = 23;
            context__.validate_dims("data initialization", "n_vars", "int", context__.to_vec());
            n_vars = int(0);
            vals_i__ = context__.vals_i("n_vars");
            pos__ = 0;
            n_vars = vals_i__[pos__++];
            current_statement_begin__ = 24;
            context__.validate_dims("data initialization", "n_rand", "int", context__.to_vec());
            n_rand = int(0);
            vals_i__ = context__.vals_i("n_rand");
            pos__ = 0;
            n_rand = vals_i__[pos__++];
            current_statement_begin__ = 25;
            context__.validate_dims("data initialization", "n_grp", "int", context__.to_vec());
            n_grp = int(0);
            vals_i__ = context__.vals_i("n_grp");
            pos__ = 0;
            n_grp = vals_i__[pos__++];
            current_statement_begin__ = 26;
            validate_non_negative_index("X", "N", N);
            validate_non_negative_index("X", "n_vars", n_vars);
            context__.validate_dims("data initialization", "X", "matrix_d", context__.to_vec(N,n_vars));
            X = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N, n_vars);
            vals_r__ = context__.vals_r("X");
            pos__ = 0;
            size_t X_j_2_max__ = n_vars;
            size_t X_j_1_max__ = N;
            for (size_t j_2__ = 0; j_2__ < X_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < X_j_1_max__; ++j_1__) {
                    X(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 28;
            context__.validate_dims("data initialization", "has_random", "int", context__.to_vec());
            has_random = int(0);
            vals_i__ = context__.vals_i("has_random");
            pos__ = 0;
            has_random = vals_i__[pos__++];
            check_greater_or_equal(function__, "has_random", has_random, 0);
            check_less_or_equal(function__, "has_random", has_random, 1);
            current_statement_begin__ = 29;
            validate_non_negative_index("groups", "n_rand", n_rand);
            context__.validate_dims("data initialization", "groups", "int", context__.to_vec(n_rand));
            groups = std::vector<int>(n_rand, int(0));
            vals_i__ = context__.vals_i("groups");
            pos__ = 0;
            size_t groups_k_0_max__ = n_rand;
            for (size_t k_0__ = 0; k_0__ < groups_k_0_max__; ++k_0__) {
                groups[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 30;
            validate_non_negative_index("rand_x", "N", N);
            validate_non_negative_index("rand_x", "n_rand", n_rand);
            context__.validate_dims("data initialization", "rand_x", "matrix_d", context__.to_vec(N,n_rand));
            rand_x = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N, n_rand);
            vals_r__ = context__.vals_r("rand_x");
            pos__ = 0;
            size_t rand_x_j_2_max__ = n_rand;
            size_t rand_x_j_1_max__ = N;
            for (size_t j_2__ = 0; j_2__ < rand_x_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < rand_x_j_1_max__; ++j_1__) {
                    rand_x(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 31;
            validate_non_negative_index("rand_sigma", "n_grp", n_grp);
            context__.validate_dims("data initialization", "rand_sigma", "vector_d", context__.to_vec(n_grp));
            rand_sigma = Eigen::Matrix<double, Eigen::Dynamic, 1>(n_grp);
            vals_r__ = context__.vals_r("rand_sigma");
            pos__ = 0;
            size_t rand_sigma_j_1_max__ = n_grp;
            for (size_t j_1__ = 0; j_1__ < rand_sigma_j_1_max__; ++j_1__) {
                rand_sigma(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "rand_sigma", rand_sigma, 0);
            current_statement_begin__ = 35;
            validate_non_negative_index("std_curve_alpha", "N", N);
            context__.validate_dims("data initialization", "std_curve_alpha", "double", context__.to_vec(N));
            std_curve_alpha = std::vector<double>(N, double(0));
            vals_r__ = context__.vals_r("std_curve_alpha");
            pos__ = 0;
            size_t std_curve_alpha_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < std_curve_alpha_k_0_max__; ++k_0__) {
                std_curve_alpha[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 36;
            validate_non_negative_index("std_curve_beta", "N", N);
            context__.validate_dims("data initialization", "std_curve_beta", "double", context__.to_vec(N));
            std_curve_beta = std::vector<double>(N, double(0));
            vals_r__ = context__.vals_r("std_curve_beta");
            pos__ = 0;
            size_t std_curve_beta_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < std_curve_beta_k_0_max__; ++k_0__) {
                std_curve_beta[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 37;
            context__.validate_dims("data initialization", "upper_Cq", "double", context__.to_vec());
            upper_Cq = double(0);
            vals_r__ = context__.vals_r("upper_Cq");
            pos__ = 0;
            upper_Cq = vals_r__[pos__++];
            current_statement_begin__ = 40;
            context__.validate_dims("data initialization", "p_zero", "double", context__.to_vec());
            p_zero = double(0);
            vals_r__ = context__.vals_r("p_zero");
            pos__ = 0;
            p_zero = vals_r__[pos__++];
            check_greater_or_equal(function__, "p_zero", p_zero, 0);
            check_less_or_equal(function__, "p_zero", p_zero, 1);
            current_statement_begin__ = 42;
            context__.validate_dims("data initialization", "sigma_ln_eDNA", "double", context__.to_vec());
            sigma_ln_eDNA = double(0);
            vals_r__ = context__.vals_r("sigma_ln_eDNA");
            pos__ = 0;
            sigma_ln_eDNA = vals_r__[pos__++];
            check_greater_or_equal(function__, "sigma_ln_eDNA", sigma_ln_eDNA, 0);
            current_statement_begin__ = 43;
            validate_non_negative_index("betas", "n_vars", n_vars);
            context__.validate_dims("data initialization", "betas", "vector_d", context__.to_vec(n_vars));
            betas = Eigen::Matrix<double, Eigen::Dynamic, 1>(n_vars);
            vals_r__ = context__.vals_r("betas");
            pos__ = 0;
            size_t betas_j_1_max__ = n_vars;
            for (size_t j_1__ = 0; j_1__ < betas_j_1_max__; ++j_1__) {
                betas(j_1__) = vals_r__[pos__++];
            }
            // initialize transformed data variables
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_eDNA_sim_omni() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            // model body
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("Cq_star");
        names__.push_back("ln_conc_star");
        names__.push_back("ln_conc_hat");
        names__.push_back("rand_betas");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((has_random ? n_rand : 0 ));
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_eDNA_sim_omni_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            if (!include_gqs__ && !include_tparams__) return;
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 60;
            validate_non_negative_index("Cq_star", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> Cq_star(N);
            stan::math::initialize(Cq_star, DUMMY_VAR__);
            stan::math::fill(Cq_star, DUMMY_VAR__);
            current_statement_begin__ = 61;
            validate_non_negative_index("ln_conc_star", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> ln_conc_star(N);
            stan::math::initialize(ln_conc_star, DUMMY_VAR__);
            stan::math::fill(ln_conc_star, DUMMY_VAR__);
            current_statement_begin__ = 62;
            validate_non_negative_index("ln_conc_hat", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> ln_conc_hat(N);
            stan::math::initialize(ln_conc_hat, DUMMY_VAR__);
            stan::math::fill(ln_conc_hat, DUMMY_VAR__);
            current_statement_begin__ = 63;
            validate_non_negative_index("rand_betas", "(has_random ? n_rand : 0 )", (has_random ? n_rand : 0 ));
            Eigen::Matrix<double, Eigen::Dynamic, 1> rand_betas((has_random ? n_rand : 0 ));
            stan::math::initialize(rand_betas, DUMMY_VAR__);
            stan::math::fill(rand_betas, DUMMY_VAR__);
            // generated quantities statements
            current_statement_begin__ = 65;
            stan::math::assign(ln_conc_star, multiply(X, betas));
            current_statement_begin__ = 67;
            if (as_bool(has_random)) {
                current_statement_begin__ = 68;
                for (int i = 1; i <= n_rand; ++i) {
                    current_statement_begin__ = 69;
                    stan::model::assign(rand_betas, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (normal_rng(0, 1, base_rng__) * get_base1(rand_sigma, get_base1(groups, i, "groups", 1), "rand_sigma", 1)), 
                                "assigning variable rand_betas");
                }
                current_statement_begin__ = 71;
                stan::math::assign(ln_conc_star, add(ln_conc_star, multiply(rand_x, rand_betas)));
            }
            current_statement_begin__ = 74;
            for (int n = 1; n <= N; ++n) {
                current_statement_begin__ = 75;
                stan::model::assign(ln_conc_hat, 
                            stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                            normal_rng(get_base1(ln_conc_star, n, "ln_conc_star", 1), sigma_ln_eDNA, base_rng__), 
                            "assigning variable ln_conc_hat");
                current_statement_begin__ = 77;
                stan::model::assign(Cq_star, 
                            stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                            ((get_base1(ln_conc_hat, n, "ln_conc_hat", 1) * get_base1(std_curve_beta, n, "std_curve_beta", 1)) + get_base1(std_curve_alpha, n, "std_curve_alpha", 1)), 
                            "assigning variable Cq_star");
                current_statement_begin__ = 78;
                if (as_bool(logical_gt(get_base1(Cq_star, n, "Cq_star", 1), upper_Cq))) {
                    current_statement_begin__ = 79;
                    stan::model::assign(Cq_star, 
                                stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                                upper_Cq, 
                                "assigning variable Cq_star");
                }
                current_statement_begin__ = 82;
                if (as_bool(bernoulli_rng(p_zero, base_rng__))) {
                    current_statement_begin__ = 83;
                    stan::model::assign(Cq_star, 
                                stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                                upper_Cq, 
                                "assigning variable Cq_star");
                }
            }
            // validate, write generated quantities
            current_statement_begin__ = 60;
            size_t Cq_star_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < Cq_star_j_1_max__; ++j_1__) {
                vars__.push_back(Cq_star(j_1__));
            }
            current_statement_begin__ = 61;
            size_t ln_conc_star_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < ln_conc_star_j_1_max__; ++j_1__) {
                vars__.push_back(ln_conc_star(j_1__));
            }
            current_statement_begin__ = 62;
            size_t ln_conc_hat_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < ln_conc_hat_j_1_max__; ++j_1__) {
                vars__.push_back(ln_conc_hat(j_1__));
            }
            current_statement_begin__ = 63;
            size_t rand_betas_j_1_max__ = (has_random ? n_rand : 0 );
            for (size_t j_1__ = 0; j_1__ < rand_betas_j_1_max__; ++j_1__) {
                vars__.push_back(rand_betas(j_1__));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_eDNA_sim_omni";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
        }
        if (!include_gqs__) return;
        size_t Cq_star_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < Cq_star_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "Cq_star" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t ln_conc_star_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < ln_conc_star_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ln_conc_star" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t ln_conc_hat_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < ln_conc_hat_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ln_conc_hat" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t rand_betas_j_1_max__ = (has_random ? n_rand : 0 );
        for (size_t j_1__ = 0; j_1__ < rand_betas_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rand_betas" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
        }
        if (!include_gqs__) return;
        size_t Cq_star_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < Cq_star_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "Cq_star" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t ln_conc_star_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < ln_conc_star_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ln_conc_star" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t ln_conc_hat_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < ln_conc_hat_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ln_conc_hat" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t rand_betas_j_1_max__ = (has_random ? n_rand : 0 );
        for (size_t j_1__ = 0; j_1__ < rand_betas_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rand_betas" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
}; // model
}  // namespace
typedef model_eDNA_sim_omni_namespace::model_eDNA_sim_omni stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
