% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wave_data.R
\name{wave_data}
\alias{wave_data}
\title{Data Generation for 2D Sine and Cosine Waves}
\usage{
wave_data(
  start,
  end,
  size = 1,
  type = "sin",
  orientation = "horizontal",
  freq = 3,
  n_points = 500,
  color = NULL,
  fill = NULL,
  group_var = FALSE,
  dampen = NULL,
  amplify = NULL
)
}
\arguments{
\item{start}{Numeric value. The starting point of the wave on the coordinate system. By default refers to the x-axis. Will refer to the y-axis if \code{orientation} is set to \code{vertical}. Must be of length 1.}

\item{end}{Numeric value. The ending point of the wave on the coordinate system. By default refers to the x-axis. Will refer to the y-axis if \code{orientation} is set to \code{vertical} Must be of length 1.}

\item{size}{Numeric value. The height or width of the wave. Orientation is set to \code{horizontal} by default, thus size will affect height by default. When orientation is set to \code{vertical}, size controls the width of the wave. Must be a positive numeric value. Must be of length 1.}

\item{type}{String value. "sin" or "cos" for sine or cosine waves. \code{sin} is default. Must be of length 1.}

\item{orientation}{String value. Default is \code{horizontal} which will draw the wave from left to right (x-axis) on the coordinate system. \code{vertical} will draw the wave from bottom to top (y-axis) on the coordinate system. Must be of length 1.}

\item{freq}{Numeric value. Default is 3 cycles per second. This affects how many "peaks" are created in the wave. Must be a positive numeric value. Must be of length 1.}

\item{n_points}{Numeric value. Default is 500. This determines how many points each half of the wave will have. This option can come in handy when using jitter options or other texture/illusion methods. Must be of length 1.}

\item{color}{Optional String Value. A 6 digit hexadecimal webcolor code, or \code{R} \code{colors()} color string for the border color of the wave. Must be of length 1.}

\item{fill}{Optional String Value. A 6 digit hexadecimal webcolor code, or \code{R} \code{colors()} color string for the fill color of the wave. Must be of length 1.}

\item{group_var}{Logic value. \code{TRUE} or \code{FALSE}. Default is \code{FALSE}. If \code{TRUE}, Adds a group variable to the data frame. Useful for iterative work to make multiple waves in a single data frame.}

\item{dampen}{Optional. A factor in which to dampen the wave (make "flatter"). Must be of length 1.}

\item{amplify}{Optional. A factor in which to amplify the wave (make "sharper"). Must be of length 1.}
}
\value{
A Tibble
}
\description{
A tool for making data frames filled with data that displays sine or cosine waves when graphed.

The \code{geom_path} and \code{geom_polygon} geoms are recommended with this data for use in \code{ggplot2} for generative art.
}
\examples{
\dontshow{if (rlang::is_installed("ggplot2")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontshow{\}) # examplesIf}
library(ggplot2)
wave_df <- wave_data(
  start = 0, end = 10,
  fill = "purple",
  color = "green"
)

wave_df |>
  ggplot(aes(x, y)) +
  theme_void() +
  geom_polygon(
    fill = wave_df$fill,
    color = wave_df$color,
    linewidth = 3
  ) +
  coord_equal()

}
