% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setsItemwise.R
\name{itemwiseSetOps}
\alias{itemwiseSetOps}
\alias{itemSetOperations}
\alias{itemUnion}
\alias{itemSetdiff}
\alias{itemIntersect}
\alias{itemUnion,itemMatrix,itemMatrix-method}
\alias{itemSetdiff,itemMatrix,itemMatrix-method}
\alias{itemIntersect,itemMatrix,itemMatrix-method}
\title{Itemwise Set Operations}
\usage{
itemUnion(x, y)

itemSetdiff(x, y)

itemIntersect(x, y)

\S4method{itemUnion}{itemMatrix,itemMatrix}(x, y)

\S4method{itemSetdiff}{itemMatrix,itemMatrix}(x, y)

\S4method{itemIntersect}{itemMatrix,itemMatrix}(x, y)
}
\arguments{
\item{x, y}{two \link{itemMatrix} objects with the same number of rows (itemsets).}
}
\value{
An object of class \link{itemMatrix} is returned.
}
\description{
Provides the generic functions and the methods for itemwise set
operations on items in an \link{itemMatrix}. The regular set operations regard each
itemset in an \code{itemMatrix} as an element. Itemwise operations regard each item
as an element and operate on the items of pairs of corresponding itemsets
(first itemset in \code{x} with first itemset in \code{y}, second with second, etc.).
}
\examples{
data("Adult")

fsets <- eclat(Adult, parameter = list(supp = 0.5))
inspect(fsets[1:4])
inspect(itemUnion(items(fsets[1:2]), items(fsets[3:4])))
inspect(itemSetdiff(items(fsets[1:2]), items(fsets[3:4])))
inspect(itemIntersect(items(fsets[1:2]), items(fsets[3:4])))
}
\author{
Michael Hahsler
}
\concept{itemMatrix and transactions Functions}
\keyword{manip}
