% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert-is-code.R, R/is-code.R
\name{assert_has_arg}
\alias{assert_has_arg}
\alias{has_arg}
\alias{has_arg_}
\title{Does the current call have an argument?}
\usage{
assert_has_arg(x, fn = sys.function(sys.parent()),
  severity = getOption("assertive.severity", "stop"))

has_arg(x, fn = sys.function(sys.parent()))

has_arg_(x, fn = sys.function(sys.parent()))
}
\arguments{
\item{x}{Argument to check.}

\item{fn}{Function to find the argument in.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}
}
\value{
\code{has_arg} reimplements \code{\link[methods]{hasArg}}, 
letting you choose the function to search in, and providing more
information on failure.
}
\description{
Checks to see if the current call has an argument with 
the name given in the input.
}
\note{
\code{has_arg} is for interactive use and takes an unquoted argument 
name; \code{has_arg_} is for programmatic use and takes a string naming a 
argument.
}
\examples{
has_arg(x, mean.default)
has_arg(y, mean.default)   
f <- function(...) has_arg(z)   
f(z = 123)
f(123)
}
\seealso{
\code{\link[methods]{hasArg}}.
}
