% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert-is-data.R, R/is-data.R
\name{assert_all_are_ip_addresses}
\alias{assert_all_are_ip_addresses}
\alias{assert_any_are_ip_addresses}
\alias{is_ip_address}
\title{Does the character vector contain IP addresses?}
\usage{
assert_all_are_ip_addresses(x, na_ignore = FALSE,
  severity = getOption("assertive.severity", "stop"))

assert_any_are_ip_addresses(x, na_ignore = FALSE,
  severity = getOption("assertive.severity", "stop"))

is_ip_address(x)
}
\arguments{
\item{x}{Input to check.}

\item{na_ignore}{A logical value.  If \code{FALSE}, \code{NA} values
cause an error; otherwise they do not.  Like \code{na.rm} in many
stats package functions, except that the position of the failing
values does not change.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}
}
\value{
A logical vector that is \code{TRUE} when the input contains valid IP 
addresses.
}
\description{
Checks that the input contains IP addresses.  (It does not check that the 
address exists, merely that the string is in a suitable format.)
}
\note{
Valid IP addresses are considered to be four integers in the range 0 to 
255, separated by dots, or the string "localhost".
}
\examples{
x <- c(
  localhost     = "localhost", 
  valid_address = "255.0.255.0", 
  out_of_range  = "1.2.3.256",
  five_blocks   = "1.2.3.4.5",
  non_numeric   = "1.2.3.Z",
  missing_block = "1.2.3.NA",
  missing       = NA
)
is_ip_address(x)
assert_any_are_ip_addresses(x)
#These examples should fail.
assertive.base::dont_stop(assert_all_are_ip_addresses(x))
}
