% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert-is-a-type.R, R/assert-is-type-base.R, R/is-a-type.R, R/is-type-base.R
\name{assert_is_a_complex}
\alias{assert_is_a_complex}
\alias{assert_is_complex}
\alias{is_a_complex}
\alias{is_complex}
\title{Is the input complex?}
\usage{
assert_is_a_complex(x, severity = getOption("assertive.severity", "stop"))

assert_is_complex(x, severity = getOption("assertive.severity", "stop"))

is_a_complex(x, .xname = get_name_in_parent(x))

is_complex(x, .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{Input to check.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}

\item{.xname}{Not intended to be used directly.}
}
\value{
\code{is_complex} wraps \code{is.complex}, providing more 
information on failure. \code{is_a_complex} returns \code{TRUE} if the 
input is complex and scalar.  The \code{assert_*} functions return
nothing but throw an error if the corresponding \code{is_*} function
returns \code{FALSE}.
}
\description{
Checks to see if the input is complex.
}
\examples{
assert_is_complex(c(1i, 2i))
assert_is_a_complex(1i)
assert_is_a_complex(1 + 0i)
assert_is_a_complex(NA_complex_)
#These examples should fail.
assertive.base::dont_stop(assert_is_complex(1:10))
assertive.base::dont_stop(assert_is_a_complex(c(1i, 2i)))
assertive.base::dont_stop(assert_is_a_complex(complex()))
}
\seealso{
\code{\link[base]{is.complex}} and \code{\link{is_scalar}}.
}

