% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attrCUSUM_getxxx_and_utils.R
\name{getAve}
\alias{getAve}
\title{Compute ATSs and Other Informations on Attribute VSI CUSUM Chart}
\usage{
getAve(refv, contl, c.zero = 0, warnl = 0, ds = 1, dl = NULL,
  di = NULL, process, maxndec = 7L, maxnumsubI = 6000L)
}
\arguments{
\item{refv}{A reference value of CUSUM statistic.}

\item{contl}{A control limit in CUSUM control scheme.}

\item{c.zero}{An initial state of CUSUM statistic (default is 0).}

\item{warnl}{A warning limit in VSI control scheme (default is 0).}

\item{ds}{The shorter sampling interval in VSI CUSUM control scheme (default is 1).}

\item{dl}{The longer sampling interval in VSI CUSUM control scheme.}

\item{di}{The sampling interval at initial state in VSI CUSUM control scheme.}

\item{process}{An object of function
standing for pmf of count process of interest. See 'Details'.}

\item{maxndec}{The maximum number of decimal places
of \code{refv} (\eqn{\le} 7L).}

\item{maxnumsubI}{The maximum number of sub-intervals in [100,6000] to be used in
applying the Markov chain approach.}
}
\value{
A list including followings:
   \item{endpoints}{Endpoints used for
     implementation of a matrix of transition probabilities.}
   \item{numsubI}{Number of sub-intervals used for
     implementation of a matrix of transition probabilities.}
   \item{lensubI}{Length of sub-intervals used for
     implementation of a matrix of transition probabilities.}
   \item{Q}{A matrix of transition probabilities for Markov chain approach.}
   \item{I_minus_Q}{Matrix \code{(I - Q)}
     where \code{I} is an identity matrix of the same size as the \code{Q}.}
   \item{I_minus_Q_inv}{Inverse matrix of \code{(I - Q)}.}
   \item{I_minus_Q_inv_1}{Row sums of \code{I_minus_Q_inv}.}
   \item{initpr}{A matrix of initial probabilities
     for Markov chain approach.}
   \item{ds}{The shorter sampling interval in VSI CUSUM control scheme.}
   \item{dl}{The longer sampling interval in VSI CUSUM control scheme.}
   \item{di}{The sampling interval at initial state
     in VSI CUSUM control scheme.}
   \item{psi.s}{Long-run proportion of shorter sampling intervals
     except initial state. See details}
   \item{psi.l}{Long-run proportion of longer sampling intervals
     except initial state. See details}
   \item{refv.act}{A reference value of CUSUM statistic used actually for
     computation.}
   \item{contl.act}{A control limit in CUSUM control scheme used actually for
     computation.}
   \item{warnl.act}{A warning limit in VSI control scheme used actually for
     computation.}
   \item{c.zero.act}{An initial state of CUSUM statistic used actually for
     computation.}
   \item{ANSS}{The computed average number of samples to signal for
     FSI CUSUM chart.}
   \item{ATS}{The computed average time to signal for
     FSI CUSUM chart.}
}
\description{
Computation of ANSSs, ATSs and other related informations on
  attribute VSI CUSUM control chart for mean increase
  based on the Markov chain approach.
}
\details{
For CUSUM control chart for detecting mean increase,
   the CUSUM statistic \eqn{(C_{t})} are defined as following:
   \deqn{C_{t}=max(C_{t-1}, 0) + X_{t} - k,    t=1,2,...,}
   wherein \eqn{X_{t}} is a count process of interest,
   \eqn{k} is the reference value and \eqn{C_{0}} is the initial state.

   The argument \code{process} is an object of function such that
   for given integer-valued vector \code{x},
   \code{process(x)} returns \eqn{P(X=x)}
   where \eqn{X} is a random variable of interest.

   If the number of sub-intervals
   for transient states of Markov chain is greater than \code{maxnsubI},
   it will be set to be a suitable value
   being less than or equal \code{maxnsubI}.

   For ANSS,
   it is the same as that \code{psi.s + psi.l + 1}.

   For ATS,
   it is the same as that \code{(psi.s * ds) + (psi.l * dl) + di}.

   Invalid arguments rise an error with a helpful message.

   This function currently provides only the case for monitoring of mean increase.
   We leave other issues as our future work.
}
\examples{
# Example 1: Poisson distribution
getAve(refv = 5, contl = 8, c.zero = 0, warnl = 1, ds = 0.1,
       dl = NULL, di = NULL, process = function(x) dpois(x, lambda = 4),
       maxndec = 7L, maxnumsubI = 500L)
}
\references{
Reynolds et al. (1990).
   CUSUM Charts with Variable Sampling Intervals,
   \emph{Technometrics}, 32(4), 371-384.
}
\seealso{
\code{\link{getContl}}, \link{getAve_Poisson},
  \link{getAve_binomial}.
}

