% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCumulativeGain.R
\name{plotCumulativeGain}
\alias{plotCumulativeGain}
\title{Cumulative Gain Chart}
\usage{
plotCumulativeGain(object, ...)
}
\arguments{
\item{object}{An object of class ModelAudit.}

\item{...}{Other modelAudit objects to be plotted together.}
}
\value{
ggplot object
}
\description{
Cumulative Gain Chart is is a plot of the rate of positive prediction against true positive rate for the different thresholds.
It is useful for measuring and comparing the accuracy of the classificators.
}
\examples{
library(mlbench)
data("PimaIndiansDiabetes")
Pima <- PimaIndiansDiabetes
Pima$diabetes <- ifelse(Pima$diabetes == "pos", 1, 0)
glm_model <- glm(diabetes~., family=binomial,	data=Pima)
glm_au <- audit(glm_model, data = Pima, y = Pima$diabetes)
plotCumulativeGain(glm_au)

}
\seealso{
\code{\link{plot.modelAudit}}
}
