% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAutocorrelation.R
\name{plotAutocorrelation}
\alias{plotAutocorrelation}
\title{Autocorrelation Plot}
\usage{
plotAutocorrelation(object, ..., variable = NULL, score = FALSE)
}
\arguments{
\item{object}{An object of class modelAudit or modelResiduals.}

\item{...}{Other modelAudit or modelResiduals objects to be plotted together.}

\item{variable}{Only for modelAudit object. Name of model variable to order residuals. If value is NULL data order is taken. If value is "Predicted response" or "Fitted values" then data is ordered by fitted values. If value is "Observed response" the data is ordered by a vector of actual response (\code{y} parameter passed to the \code{\link{audit}} function).}

\item{score}{Logical, if TRUE values of \link{scoreDW} and \link{scoreRuns} will be added to plot.}
}
\description{
Plot of i-th residual vs i+1-th residual.
}
\examples{
library(car)
lm_model <- lm(prestige~education + women + income, data = Prestige)
lm_au <- audit(lm_model, data = Prestige, y = Prestige$prestige)
plotAutocorrelation(lm_au)

}
