% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_rroc.R
\name{score_rroc}
\alias{score_rroc}
\alias{scoreRROC}
\title{Area Over the Curve for RROC Curves}
\usage{
score_rroc(object)

scoreRROC(object)
}
\arguments{
\item{object}{An object of class 'explainer' created with function \code{\link[DALEX]{explain}} from the DALEX package.}
}
\value{
an object of class 'score_audit'.
}
\description{
The area over the Regression Receiver Operating Characteristic.
}
\examples{
dragons <- DALEX::dragons[1:100, ]

# fit a model
model_lm <- lm(life_length ~ ., data = dragons)

# create an explainer
exp_lm <- DALEX::explain(model_lm, data = dragons, y = dragons$life_length)

# calculate score
score_rroc(exp_lm)


}
\references{
Hernández-Orallo, José. 2013. ‘ROC Curves for Regression’. Pattern Recognition 46 (12): 3395–3411.
}
\seealso{
\code{\link{plot_rroc}}
}
