% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auk-last-edited.r
\name{auk_last_edited}
\alias{auk_last_edited}
\title{Filter the eBird data by last edited date}
\usage{
auk_last_edited(x, date)
}
\arguments{
\item{x}{\code{auk_ebd} or \code{auk_sampling} object; reference to file created by
\code{\link[=auk_ebd]{auk_ebd()}} or \code{\link[=auk_sampling]{auk_sampling()}}.}

\item{date}{character or date; date range to filter by, provided either as a
character vector in the format \code{"2015-12-31"} or a vector of Date objects.}
}
\value{
An \code{auk_ebd} object.
}
\description{
Define a filter for the eBird Basic Dataset (EBD) based on a range of last
edited dates. Last edited date is typically used to extract just new or
recently edited data. This function only defines the filter and, once all
filters have been defined, \code{\link[=auk_filter]{auk_filter()}} should be used to call AWK and
perform the filtering.
}
\details{
This function can also work with on an \code{auk_sampling} object if the
user only wishes to filter the sampling event data.
}
\examples{
system.file("extdata/ebd-sample.txt", package = "auk") \%>\%
  auk_ebd() \%>\%
  auk_last_edited(date = c("2010-01-01", "2010-12-31"))
}
\seealso{
Other filter: 
\code{\link{auk_bbox}()},
\code{\link{auk_bcr}()},
\code{\link{auk_breeding}()},
\code{\link{auk_complete}()},
\code{\link{auk_country}()},
\code{\link{auk_county}()},
\code{\link{auk_date}()},
\code{\link{auk_distance}()},
\code{\link{auk_duration}()},
\code{\link{auk_extent}()},
\code{\link{auk_filter}()},
\code{\link{auk_observer}()},
\code{\link{auk_project}()},
\code{\link{auk_protocol}()},
\code{\link{auk_species}()},
\code{\link{auk_state}()},
\code{\link{auk_time}()},
\code{\link{auk_year}()}
}
\concept{filter}
