% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aurelius.R
\docType{package}
\name{aurelius}
\alias{aurelius}
\alias{aurelius-package}
\title{\code{aurelius} package}
\description{
Generates PFA Documents from R Code and Optionally Runs Them
}
\details{
Converts R syntax into PFA and provides tools for assembling a PFA
document within R. Tests validity and runtime behavior of PFA by offloading
PFA and data to Titus (through rPython). Facilitates conversion of common R
model output to PFA using aurelius.* libraries.  Aurelius is part of 
Hadrian and is on Github at \url{https://github.com/opendatagroup/hadrian}.
}
\examples{
\dontrun{
library("aurelius")

# build a model
lm_model <- lm(mpg ~ hp, data = mtcars)
  
# convert the lm object to a list of lists PFA representation
lm_model_as_pfa <- pfa(lm_model)
  
# save as plain-text JSON
write_pfa(lm_model_as_pfa, file = "my-model.pfa")

# read the model back in
read_pfa(file("my-model.pfa"))
}
}
