% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbm.R
\name{extract_params.gbm}
\alias{extract_params.gbm}
\title{extract_params.gbm}
\usage{
\method{extract_params}{gbm}(object, which_tree = 1, ...)
}
\arguments{
\item{object}{an object of class "gbm"}

\item{which_tree}{the number of the tree to extract}

\item{...}{further arguments passed to or from other methods}
}
\value{
a \code{list} that is extracted from the gbm object
}
\description{
Extracts a parameters from an ensemble made by the gbm function
}
\examples{
dat <- data.frame(X1 = runif(100), 
                  X2 = rnorm(100)) 
dat$Y <- ((rexp(100,5) + 5 * dat$X1 - 4 * dat$X2) > 0)

bernoulli_model <- gbm::gbm(Y ~ X1 + X2, 
                            data = dat, 
                            distribution = 'bernoulli')
my_tree <- extract_params(bernoulli_model, 1)
}
