% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/naiveBayes.R
\name{extract_params.naiveBayes}
\alias{extract_params.naiveBayes}
\title{extract_params.naiveBayes}
\usage{
\method{extract_params}{naiveBayes}(object, threshold = 0.001, eps = 0, ...)
}
\arguments{
\item{object}{an object of class "naiveBayes"}

\item{threshold}{a value replacing cells with probabilities within eps range.}

\item{eps}{a numeric for specifying an epsilon-range to apply laplace 
smoothing (to replace zero or close-zero probabilities by theshold.)}

\item{...}{further arguments passed to or from other methods}
}
\value{
a \code{list} that is extracted from the naiveBayes object
}
\description{
Extracts a parameters from an ensemble made by the naiveBayes function
}
\examples{
model <- e1071::naiveBayes(Species ~ ., data=iris) 
model_params <- extract_params(model)
}
