% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arima.R
\name{pfa.Arima}
\alias{pfa.Arima}
\title{PFA Formatting of ARIMA Models}
\source{
pfa_config.R avro_typemap.R avro.R pfa_cellpool.R pfa_expr.R pfa_utils.R
}
\usage{
\method{pfa}{Arima}(object, name = NULL, version = NULL, doc = NULL,
  metadata = NULL, randseed = NULL, options = NULL, cycle_reset = TRUE,
  ...)
}
\arguments{
\item{object}{an object of class "Arima"}

\item{name}{a character which is an optional name for the scoring engine}

\item{version}{an integer which is sequential version number for the model}

\item{doc}{a character which is documentation string for archival purposes}

\item{metadata}{a \code{list} of strings that is computer-readable documentation for 
archival purposes}

\item{randseed}{a integer which is a global seed used to generate all random 
numbers. Multiple scoring engines derived from the same PFA file have 
different seeds generated from the global one}

\item{options}{a \code{list} with value types depending on option name 
Initialization or runtime options to customize implementation 
(e.g. optimization switches). May be overridden or ignored by PFA consumer}

\item{cycle_reset}{a logical indicating whether to reset the state back to the 
last point of the trained model before forecasting or to continue cycling forward 
through trend and seasonality with every new call to the engine. The default is 
TRUE so that repeated calls yield the same forecast as repeated calls to 
\code{\link[stats]{predict}} or \code{\link[forecast]{forecast}}.}

\item{...}{additional arguments affecting the PFA produced}
}
\value{
a \code{list} of lists that compose valid PFA document
}
\description{
This function takes an ARIMA model created using the arima(), Arima(), or auto.arima() functions 
and returns a list-of-lists representing in valid PFA document that could be used 
for scoring.
}
\examples{
model <- forecast::Arima(USAccDeaths, order=c(2,2,2), seasonal=c(0,2,2))
model_as_pfa <- pfa(model)

# with regressors
n <- 100
ext_dat <- data.frame(x1=rnorm(n), x2=rnorm(n))
x <- stats::arima.sim(n=n, model=list(ar=0.4)) + 2 + 0.8*ext_dat[,1] + 1.5*ext_dat[,2]
model <- stats::arima(x, order=c(1,0,0), xreg = ext_dat)
model_as_pfa <- pfa(model)
}
\seealso{
\code{\link[forecast]{Arima}} \code{\link[forecast]{auto.arima}} \code{\link[stats]{arima}} \code{\link{extract_params.Arima}}
}
