% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lda.R
\name{pfa.lda}
\alias{pfa.lda}
\title{PFA Formatting of Fitted Linear Discriminant Models}
\source{
pfa_config.R avro_typemap.R avro.R pfa_cellpool.R pfa_expr.R pfa_utils.R
}
\usage{
\method{pfa}{lda}(object, name = NULL, version = NULL, doc = NULL,
  metadata = NULL, randseed = NULL, options = NULL,
  prior = object$prior, dimen = length(object$svd), method = c("plug-in"),
  pred_type = c("response", "prob"), cutoffs = NULL, ...)
}
\arguments{
\item{object}{an object of class "lda"}

\item{name}{a character which is an optional name for the scoring engine}

\item{version}{an integer which is sequential version number for the model}

\item{doc}{a character which is documentation string for archival purposes}

\item{metadata}{a \code{list} of strings that is computer-readable documentation for
archival purposes}

\item{randseed}{a integer which is a global seed used to generate all random
numbers. Multiple scoring engines derived from the same PFA file have
different seeds generated from the global one}

\item{options}{a \code{list} with value types depending on option name
Initialization or runtime options to customize implementation
(e.g. optimization switches). May be overridden or ignored by PFA consumer}

\item{prior}{a named vector specifying the prior probabilities of class membership.
If unspecified, the class proportions for the training set are used.}

\item{dimen}{an integer specifying the dimension of the space to be used. 
If this is less than min(p input variables, number of classes - 1) then the 
first N number of dimensions will be used in the calculation}

\item{method}{a character string indicating the prediction method. Currently, 
only the plug-in method is supported.}

\item{pred_type}{a string with value "response" for returning a prediction on the
same scale as what was provided during modeling, or value "prob", which for classification
problems returns the probability of each class.}

\item{cutoffs}{(Classification only) A named numeric vector of length equal to
number of classes. The "winning" class for an observation is the one with the
maximum ratio of predicted probability to its cutoff. The default cutoffs assume the
same cutoff for each class that is 1/k where k is the number of classes}

\item{...}{additional arguments affecting the PFA produced}
}
\value{
a \code{list} of lists that compose valid PFA document
}
\description{
This function takes a linear discriminant model fit using lda
and returns a list-of-lists representing in valid PFA document
that could be used for scoring
}
\examples{
model <- MASS::lda(Species ~ ., data=iris)
model_as_pfa <- pfa(model)
}
\seealso{
\code{\link[MASS]{lda}} \code{\link{extract_params.lda}}
}
