# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Create an autocart model
#'
#' @param response A vector of numeric response values with no NA entries.
#' @param data A dataframe for the predictor variables used in the autocart tree.
#' @param locations A two-column matrix with coordinates for the observations the predictor dataframe.
#' @param alpha A scalar value between 0 and 1 to weight autocorrelation against reduction in variance in the tree splitting. A value of 1 indicates full weighting on measures of autocorrelation.
#' @param beta A scalar value between 0 and 1 to weight the shape of the region in the splitting
#' @param control An object of type "autocartControl" returned by the \code{autocartControl} function to control the splitting in the autocart tree.
#' @return An S3 object of class "autocart".
#'
#' @examples
#' # Load some data for an autocart example
#' snow <- na.omit(read.csv(system.file("extdata", "ut2017_snow.csv", package = "autocart")))
#' y <- snow$yr50[1:40]
#' X <- data.frame(snow$ELEVATION, snow$MCMT, snow$PPTWT, snow$HUC)[1:40, ]
#' locations <- as.matrix(cbind(snow$LONGITUDE, snow$LATITUDE))[1:40, ]
#'
#' # Create an autocart model with 50 trees
#' snow_model <- autocart(y, X, locations, 0.30, 0)
#'
#' @import fields
#' @importFrom RcppParallel RcppParallelLibs
#' @export
autocart <- function(response, data, locations, alpha, beta, control = NULL) {
    .Call(`_autocart_autocart`, response, data, locations, alpha, beta, control)
}

#' Given an autocart model object, predict for new data passed in
#'
#' @param autocartModel An S3 object of type "autocart" returned from the autocart function
#' @param newdata A dataframe with the same amount of columns used to create the autocart model.
#' @return A numeric vector containing the predicted response value for each of the rows in the passed in dataframe.
#'
#' @examples
#' # Load some data for an autocart predict example
#' snow <- na.omit(read.csv(system.file("extdata", "ut2017_snow.csv", package = "autocart")))
#' y <- snow$yr50[1:40]
#' X <- data.frame(snow$ELEVATION, snow$MCMT, snow$PPTWT, snow$HUC)[1:40, ]
#' locations <- as.matrix(cbind(snow$LONGITUDE, snow$LATITUDE))[1:40, ]
#'
#' # Create an autocart model with 50 trees
#' snow_model <- autocart(y, X, locations, 0.30, 0)
#'
#' # Predict in autocart
#' new_X <- X[1:10, ]
#' new_loc <- locations[1:10, ]
#' autocart_predictions <- predictAutocart(snow_model, new_X)
#' @export
predictAutocart <- function(autocartModel, newdata) {
    .Call(`_autocart_predictAutocart`, autocartModel, newdata)
}

