% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelling.R
\name{plot_fitness}
\alias{plot_fitness}
\title{plot_fitness}
\usage{
plot_fitness(autofit)
}
\arguments{
\item{autofit}{Output of the autohrf function.}
}
\value{
A ggplot visualization of fitness through time.
}
\description{
Plots how fitness changed through iterations of autohrf.
Use this to investigate whether your solution converged.
}
\examples{
# prepare model specs
model3 <- data.frame(
  event        = c("encoding", "delay", "response"),
  start_time   = c(0,          2.65,     12.5),
  end_time     = c(3,          12.5,     16)
)

model4 <- data.frame(
  event        = c("fixation", "target", "delay", "response"),
  start_time   = c(0,          2.5,      2.65,    12.5),
  end_time     = c(2.5,        3,        12.5,    15.5)
)

model_constraints <- list(model3, model4)

# run autohrf
df <- swm
autofit <- autohrf(df, model_constraints, tr = 2.5,
                   population = 2, iter = 2, cores = 1)

# plot fitness
plot_fitness(autofit)

}
