% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelling.R
\name{autohrf}
\alias{autohrf}
\title{autohrf}
\usage{
autohrf(
  d,
  model_constraints,
  tr,
  roi_weights = NULL,
  allow_overlap = FALSE,
  population = 100,
  iter = 100,
  mutation_rate = 0.1,
  mutation_factor = 0.05,
  elitism = 0.1,
  hrf = "spm",
  t = 32,
  p_boynton = c(2.25, 1.25, 2),
  p_spm = c(6, 16, 1, 1, 6, 0),
  f = 100,
  cores = NULL,
  autohrf = NULL,
  verbose = TRUE
)
}
\arguments{
\item{d}{A dataframe with the signal data: roi, t and y. ROI is the name of
the region, t is the timestamp and y the value of the signal.}

\item{model_constraints}{A list of model specifications to use for fitting.
Each specification is represented as a data frame containing information
about it (event, start_time, end_time, min_duration and max_duration).}

\item{tr}{MRI's repetition time.}

\item{roi_weights}{A data frame with ROI weights: roi, weight. ROI is the
name of the region, weight a number that defines the importance of that roi,
the default weight for a ROI is 1. If set to 2 for a particular ROI that ROI
will be twice as important.}

\item{allow_overlap}{Whether to allow overlap between events.}

\item{population}{The size of the population in the genetic algorithm.}

\item{iter}{Number of iterations in the genetic algorithm.}

\item{mutation_rate}{The mutation rate in the genetic algorithm.}

\item{mutation_factor}{The mutation factor in the genetic algorithm.}

\item{elitism}{The degree of elitism (promote a percentage of the best
solutions) in the genetic algorithm.}

\item{hrf}{Method to use for HRF generation.}

\item{t}{The t parameter for Boynton or SPM HRF generation.}

\item{p_boynton}{Parameters for the Boynton's HRF.}

\item{p_spm}{Parameters for the SPM HRF.}

\item{f}{Upsampling factor.}

\item{cores}{Number of cores to use for parallel processing. Set to the
number of provided model constraints by default.}

\item{autohrf}{Results of a previous autohrf run to continue.}

\item{verbose}{Whether to print progress of the fitting process.}
}
\value{
A list containing model fits for each of the provided model
specifications.
}
\description{
A function that automatically finds the parameters of model's
that best match the underlying data.
}
\examples{
# prepare model specs
model3 <- data.frame(
  event        = c("encoding", "delay", "response"),
  start_time   = c(0,          2.65,     12.5),
  end_time     = c(3,          12.5,     16)
)

model4 <- data.frame(
  event        = c("fixation", "target", "delay", "response"),
  start_time   = c(0,          2.5,      2.65,    12.5),
  end_time     = c(2.5,        3,        12.5,    15.5)
)

model_constraints <- list(model3, model4)

# run autohrf
df <- flanker
autofit <- autohrf(df, model_constraints, tr = 2.5,
                   population = 2, iter = 2, cores = 1)

}
