% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_formula.R
\name{f_modify_formula}
\alias{f_modify_formula}
\title{Modify Formula}
\usage{
f_modify_formula(
  f,
  rhs_remove = NULL,
  rhs_add = NULL,
  lhs_replace = NULL,
  negate = TRUE
)
}
\arguments{
\item{f}{formula}

\item{rhs_remove}{regex or character vector for dropping variables from the rhs}

\item{rhs_add}{character vector for adding variables to rhs}

\item{lhs_replace}{string to replace formula lhs if supplied}

\item{negate}{should \code{rhs_remove} keep or remove the specified vars. Set to \code{FALSE} to keep}
}
\value{
formula
}
\description{
Modify components of a formula by adding / removing vars from the rhs or replacing the lhs.
}
\examples{

iris \%>\%
tidy_formula(target = Species, tidyselect::everything()) -> f

f

f \%>\%
  f_modify_formula(
rhs_remove = c("Petal.Width", "Sepal.Length"),
rhs_add = "Custom_Variable"
)

f \%>\%
  f_modify_formula(
rhs_remove = "Petal",
lhs_replace = "Petal.Length"
)
}
