% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explode_dummies.r
\name{explode_dummies}
\alias{explode_dummies}
\title{Explode dummies columns into separate dummy variables}
\usage{
explode_dummies(outlier_dummies)
}
\arguments{
\item{outlier_dummies}{A matrix of outlier dummy variables in columns.}
}
\value{
A matrix with dummy variables in columns, each having one nonzero index. The columns are named \code{outlier_x}, with x being the 1-based row index of the position that this dummy variable is masking.
}
\description{
This function takes a matrix with dummy outlier columns, where there are possibly multiple ones. We first merge these columns to one and then explode them to obtain one dummy variable per column.
}
\examples{
outlier_dummies <- matrix(NA,
                          nrow = 5,
                          ncol = 3,
                         dimnames = list(NULL, c('rumination', 'happiness', 'activity')))
outlier_dummies[, 1] <- c(0, 0, 1, 0, 1)
outlier_dummies[, 2] <- c(0, 1, 1, 0, 0)
outlier_dummies[, 3] <- c(1, 0, 0, 0, 1)
outlier_dummies
autovarCore:::explode_dummies(outlier_dummies)
}
