% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_transit_gateway_route}
\alias{ec2_create_transit_gateway_route}
\title{Create Transit Gateway Route}
\usage{
ec2_create_transit_gateway_route(
  DestinationCidrBlock,
  TransitGatewayRouteTableId,
  TransitGatewayAttachmentId = NULL,
  Blackhole = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{DestinationCidrBlock}{String. The CIDR range used for destination matches.}

\item{TransitGatewayRouteTableId}{String. The ID of the transit gateway route table.}

\item{TransitGatewayAttachmentId}{String. The ID of the attachment.[optional]}

\item{Blackhole}{Logical. Indicates whether to drop traffic that matches this route.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Creates a
static route for the specified transit gateway route
table.
}
\section{DestinationCidrBlock}{

The CIDR range used for
destination matches. Routing decisions are based on the most specific
match.
}

\section{TransitGatewayRouteTableId}{

The ID of the transit gateway route
table.
}

\section{TransitGatewayAttachmentId}{

The ID of the
attachment.
}

\section{Blackhole}{

Indicates whether to drop traffic that
matches this route.
}

\section{DryRun}{

Checks whether you have the
required permissions for the action, without actually making the
request, and provides an error response. If you have the required
permissions, the error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

