% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_local_gateway_route_tables}
\alias{ec2_describe_local_gateway_route_tables}
\title{Describe Local Gateway Route Tables}
\usage{
ec2_describe_local_gateway_route_tables(
  LocalGatewayRouteTableId = NULL,
  Filter = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{LocalGatewayRouteTableId}{List. The IDs of the local gateway route tables.[optional]}

\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{MaxResults}{Integer. The maximum number of results to return with a single call.[optional]}

\item{NextToken}{Characters, The token for the next page of results[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Describes one
or more local gateway route tables. By default, all local gateway route
tables are described. Alternatively, you can filter the
results.
}
\section{LocalGatewayRouteTableId}{

The IDs of the local
gateway route tables.
}

\section{Filter}{


One or more filters.
\itemize{
\item \code{local-gateway-id} - The ID of a local gateway.
\item \code{local-gateway-route-table-id} - The ID of a local gateway route
table.
\item \code{outpost-arn} - The Amazon Resource Name (ARN) of the Outpost.
\item \code{state} - The state of the local gateway route table.
}
}

\section{MaxResults}{

The maximum number of results to return with a
single call. To retrieve the remaining results, make another call with
the returned \code{nextToken} value.
}

\section{DryRun}{

Checks whether you have the
required permissions for the action, without actually making the
request, and provides an error response. If you have the required
permissions, the error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

